/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.entity.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class MeteoServiceVersion {
    @JsonProperty
    private final int major;
    @JsonProperty
    private final int minor;

    @JsonCreator
    public MeteoServiceVersion(@JsonProperty(value="major") int major, @JsonProperty(value="minor") int minor) {
        this.major = major;
        this.minor = minor;
    }

    public String toStringVersion() {
        return String.format("%s.%s", this.major, this.minor);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeteoServiceVersion)) {
            return false;
        }
        MeteoServiceVersion other = (MeteoServiceVersion)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        return this.getMinor() == other.getMinor();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        return result;
    }

    public String toString() {
        return "MeteoServiceVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }
}

