/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples;

import java.util.Date;
import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.sunrise.Sunrise;
import no.api.meteo.entity.core.service.sunrise.SunriseDate;
import no.api.meteo.examples.LocationExample;
import no.api.meteo.service.sunrise.SunriseService;
import no.api.meteo.util.MeteoDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunriseExample {
    public static final double LONGITUDE_OSLO = 10.7460923576733;
    public static final double LATITUDE_OSLO = 59.912726542422;
    private static final Logger log = LoggerFactory.getLogger(LocationExample.class);
    private MeteoClient meteoClient = new DefaultMeteoClient();

    public MeteoData<Sunrise> runExample() {
        SunriseService sunriseService = new SunriseService(this.meteoClient);
        try {
            return sunriseService.fetchContent(10.7460923576733, 59.912726542422, new Date());
        }
        catch (MeteoException e) {
            log.error("Caught exception : " + e.getMessage());
            return null;
        }
    }

    public void shutDown() {
        this.meteoClient.shutdown();
    }

    public static void main(String[] args) {
        SunriseExample sunriseExample = new SunriseExample();
        MeteoData<Sunrise> data = sunriseExample.runExample();
        if (data == null || data.getResult() == null || ((Sunrise)data.getResult()).getDates() == null || ((Sunrise)data.getResult()).getDates().size() < 1) {
            log.error("Something went wrong!");
        } else {
            SunriseDate sunriseDate = (SunriseDate)((Sunrise)data.getResult()).getDates().get(0);
            log.info("On " + MeteoDateUtils.dateToYyyyMMdd((Date)sunriseDate.getDate()) + " the sun will rise at " + MeteoDateUtils.dateToHHmm((Date)sunriseDate.getSun().getRise()) + " in Oslo");
        }
    }
}

