/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples.extras;

import java.util.List;
import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.locationforecast.LocationForecast;
import no.api.meteo.entity.extras.MeteoExtrasForecast;
import no.api.meteo.examples.AbstractExample;
import no.api.meteo.service.locationforecast.LocationforecastLTSService;
import no.api.meteo.services.LocationForecastHelper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForecastsByHourExample
extends AbstractExample {
    public static final double LONGITUDE_OSLO = 10.7460923576733;
    public static final double LATITUDE_OSLO = 59.912726542422;
    public static final int ALTITUDE_OSLO = 14;
    private static final Logger log = LoggerFactory.getLogger(ForecastsByHourExample.class);
    public static final int HOURS = 10;
    public static final int TWELVE_O_CLOCK = 12;
    private MeteoClient meteoClient = new DefaultMeteoClient();

    public void runExample() {
        try {
            LocationforecastLTSService service = new LocationforecastLTSService(this.meteoClient);
            MeteoData meteoData = service.fetchContent(10.7460923576733, 59.912726542422, 14);
            LocationForecastHelper locationForecastHelper = new LocationForecastHelper((LocationForecast)meteoData.getResult());
            List list = locationForecastHelper.findHourlyPointForecastsFromNow(10);
            log.info("Got " + list.size() + " forecasts.");
            for (MeteoExtrasForecast extras : list) {
                this.prettyLogPeriodForecast(extras.getPeriodForecast());
            }
            DateTime dateTime = new DateTime();
            dateTime = dateTime.withHourOfDay(12).withMinuteOfHour(0).withSecondOfMinute(0);
            locationForecastHelper.findNearestForecast(dateTime.plusDays(2).toDate());
        }
        catch (MeteoException e) {
            log.error("Something went wrong", (Throwable)e);
        }
    }

    public void shutDown() {
        this.meteoClient.shutdown();
    }

    public static void main(String[] args) {
        ForecastsByHourExample forecastsByHourExample = new ForecastsByHourExample();
        forecastsByHourExample.runExample();
    }
}

