/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples;

import java.util.Date;
import no.api.meteo.entity.core.service.locationforecast.PeriodForecast;
import no.api.meteo.entity.core.service.locationforecast.Precipitation;
import no.api.meteo.util.MeteoDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExample {
    private static final Logger log = LoggerFactory.getLogger(AbstractExample.class);

    public void prettyLogPeriodForecast(PeriodForecast periodForecast) {
        if (periodForecast == null) {
            log.error("Period forecast -> null");
        } else {
            log.error("Period forecast -> from:" + MeteoDateUtils.dateToString((Date)periodForecast.getFromTime(), (String)"yyyy-MM-dd HH:mm") + ", to:" + MeteoDateUtils.dateToString((Date)periodForecast.getToTime(), (String)"yyyy-MM-dd HH:mm"));
            this.prettyLogPrecipitation(periodForecast.getPrecipitation());
        }
    }

    public void prettyLogPrecipitation(Precipitation precipitation) {
        if (precipitation == null) {
            log.error("  Precipitation -> null");
        } else {
            log.error("  Precipitation -> unit:" + precipitation.getUnit() + ", maxValue:" + precipitation.getMaxValue() + ", minValue:" + precipitation.getMinValue() + ", value:" + precipitation.getValue() + ", probability:" + precipitation.getProbability());
        }
    }
}

