/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples;

import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.locationforecast.LocationForecast;
import no.api.meteo.entity.core.service.locationforecast.Model;
import no.api.meteo.service.locationforecast.LocationforecastLTSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationExample {
    public static final double LONGITUDE_OSLO = 10.7460923576733;
    public static final double LATITUDE_OSLO = 59.912726542422;
    public static final int ALTITUDE_OSLO = 14;
    private static final Logger log = LoggerFactory.getLogger(LocationExample.class);
    private final MeteoClient meteoClient = new DefaultMeteoClient();

    public MeteoData<LocationForecast> runExample() {
        LocationforecastLTSService ltsService = new LocationforecastLTSService(this.meteoClient);
        try {
            return ltsService.fetchContent(10.7460923576733, 59.912726542422, 14);
        }
        catch (MeteoException e) {
            log.error("Caught exception : " + e.getMessage());
            return null;
        }
    }

    public void shutDown() {
        this.meteoClient.shutdown();
    }

    public static void main(String[] args) {
        LocationExample locationExample = new LocationExample();
        MeteoData<LocationForecast> data = locationExample.runExample();
        for (Model m : ((LocationForecast)data.getResult()).getMeta().getModels()) {
            log.info("Model Name: " + m.getName());
        }
    }
}

