/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.servlet;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.locationforecast.LocationForecast;
import no.api.meteo.service.locationforecast.LocationforecastLTSService;
import no.api.meteo.services.LocationForecastHelper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LocationServlet.class);
    private static final MeteoClient METEO_CLIENT = new DefaultMeteoClient();
    public static final int HOURS_24 = 24;
    public static final int TWELVE_O_CLOCK = 12;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("issearch") != null && req.getParameter("issearch").equals("true")) {
            req.setAttribute("search", (Object)true);
            req.setAttribute("longitude", (Object)req.getParameter("longitude"));
            req.setAttribute("latitude", (Object)req.getParameter("latitude"));
            req.setAttribute("altitude", (Object)req.getParameter("altitude"));
            double longitude = Double.valueOf(req.getParameter("longitude"));
            double latitude = Double.valueOf(req.getParameter("latitude"));
            int altitude = Integer.valueOf(req.getParameter("altitude"));
            try {
                Optional afterForecast;
                Optional tomorrowForecast;
                LocationforecastLTSService service = new LocationforecastLTSService(METEO_CLIENT);
                MeteoData meteoData = service.fetchContent(longitude, latitude, altitude);
                LocationForecastHelper helper = new LocationForecastHelper((LocationForecast)meteoData.getResult());
                req.setAttribute("data", meteoData.getResult());
                req.setAttribute("raw", (Object)meteoData.getResponse().getData());
                List last24 = helper.findHourlyPointForecastsFromNow(24);
                req.setAttribute("last24", (Object)last24);
                DateTime firstDate = new DateTime();
                firstDate = firstDate.withHourOfDay(12).withMinuteOfHour(0).withSecondOfMinute(0);
                Optional todayForecast = helper.findNearestForecast(firstDate.toDate());
                if (todayForecast.isPresent()) {
                    req.setAttribute("today", todayForecast.get());
                }
                if ((tomorrowForecast = helper.findNearestForecast(firstDate.plusDays(1).toDate())).isPresent()) {
                    req.setAttribute("tomorrow", tomorrowForecast.get());
                }
                if ((afterForecast = helper.findNearestForecast(firstDate.plusDays(2).toDate())).isPresent()) {
                    req.setAttribute("thedayaftertomorrow", afterForecast.get());
                }
            }
            catch (MeteoException e) {
                log.error("Caught exception", (Throwable)e);
            }
        } else {
            req.setAttribute("search", (Object)false);
        }
        this.getServletContext().getRequestDispatcher("/WEB-INF/jsp/locationtest.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }
}

