<#include "header.ftl">

<div class="jumbotron">
    <div class="container">
        <p>
        <form class="navbar-form navbar" action="" method="get">
            <div class="form-group">
                <input type="hidden" name="issearch" value="true"/>
                <input placeholder="Longitude" class="form-control" name="longitude" type="dec" pattern="^\d*\.\d*$"
                       size="20" value="${longitude!""}"/>
                <input placeholder="Latitude" class="form-control" name="latitude" type="dec" pattern="^\d*\.\d*$"
                       size="20" value="${latitude!""}"/>
                <input placeholder="Altitude" class="form-control" name="altitude" type="dec" pattern="^\d*(\.\d*)?$"
                       size="20" value="${altitude!""}" title="Must be a number!" on/>
                <input class="btn btn-success" type="submit" value="search"/>
            </div>
        </form>
        </p>
        <p>
            <a href="/location?issearch=true&longitude=10.7460923576733&latitude=59.912726542422&altitude=14&p=1">Oslo</a> |
            <a href="/location?issearch=true&longitude=10.8039&latitude=59.8106&altitude=105&p=2">Kolbotn</a> |
            <a href="/location?issearch=true&longitude=13.41053&latitude=52.52437&altitude=74&p=3">Berlin</a> |
            <a href="/location?issearch=true&longitude=10.6915510490055&latitude=60.7957437316181&altitude=129&p=4">Gj&oslash;vik</a>
        </p>
    </div>
</div>

<div class="container">
    <div class="row">
        <div class="col-md-12">

        <#if search>

            <ul id="myTab" class="nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#view" id="view-tab" role="tab" data-toggle="tab" aria-controls="view" aria-expanded="true">View</a>
                </li>
                <li role="presentation">
                    <a href="#data" role="tab" id="data-tab" data-toggle="tab" aria-controls="data">XML</a>
                </li>
            </ul>

            <div id="myTabContent" class="tab-content">
                <div role="tabpanel" class="tab-pane fade in active" id="view" aria-labelledBy="view-tab">
                    <h3>Forecast for the next days</h3>

                    <p>Please note that we do not show night symbols in this demo as it requires a combined use with the Sunrise API.</p>

                    <!--<h4>Today</h4>
                    <table class="dataTable">
                        <thead>
                        <tr>
                            <th>Time</th>
                            <th>Prediction</th>
                            <th>Temperature</th>
                            <th>Precipitation</th>
                            <th>Wind</th>
                        </tr>
                        </thead>
                        <tr>
                            <td>22</td>
                            <td>22</td>
                            <td>22</td>
                            <td>22</td>
                            <td>22</td>
                        </tr>
                    </table>-->

                    <h4>Tomorrow (From yr.no for comparison)</h4>

                    <#if p == "1">
                        <p><img src="http://www.yr.no/sted/Norge/Oslo/Oslo/Oslo/meteogram.png"/></p>
                    <#elseif p == "2">
                        <p><img src="http://www.yr.no/sted/Norge/Akershus/Oppeg%C3%A5rd/Kolbotn/meteogram.png"/></p>
                    <#elseif p == "3">
                        <p><img src="http://www.yr.no/sted/Tyskland/Berlin/Berlin/meteogram.png"/></p>
                    <#elseif p == "4">
                        <p><img src="http://www.yr.no/sted/Norge/Oppland/Gj%C3%B8vik/Gj%C3%B8vik/meteogram.png"/></p>
                    </#if>

                    <h3>24 hour presentation (Generated by Meteo)</h3>

                    <p>
                    <#if last24??>
                        <table class="dataTable">
                            <tr>
                                <#list last24 as pair>
                                    <#if pair?is_even_item>
                                        <td class="hourpres" width="65">
                                            <#assign periodInfo>
                                                <span class="hourdate">Date: ${pair.pointForecast.from.format('dd-MM-yy')}</span><br/>
                                                From PeriodForecast:<br/>${pair.periodForecast.from.format('dd-MM-yy HH:mm Z')}
                                                <br/>
                                                ${pair.periodForecast.to.format('dd-MM-yy HH:mm Z')}
                                                <br/>
                                                Symbol : ${pair.periodForecast.symbol.number}
                                            </#assign>
                                            <img  data-toggle="tooltip" title="" data-original-title="${periodInfo?html}" src="/images/weather/${pair.periodForecast.symbol.number}.png"/><br/>
                                            <span class="hourdate">${pair.pointForecast.from.format('HH:mm')}</span><br/>
                                            <span class="hourtemp">${pair.pointForecast.temperature.value?string["0"]}&#8451;</span><br/>
                                            <span class="hourpre">${pair.periodForecast.precipitation.minValue?string["0.0"]} - ${pair.periodForecast.precipitation.maxValue?string["0.0"]}"mm</span><br/>
                                            <img src="/images/wind/${pair.pointForecast.windDirection.name?lower_case}${pair.pointForecast.windSpeed.beaufort?string["00"]}.png"/>
                                            <span class="hourdate">${pair.pointForecast.windDirection.name} (${pair.pointForecast.windDirection.deg})</span><br/>
                                        </td>
                                    </#if>
                                </#list>
                            </tr>
                        </table>
                    <#else>
                        Could not fetch 24 hour forecast.
                    </#if>
                    </p>

                    <h3>3 days</h3>

                    <#assign tpe = today.periodForecast>
                    <#assign tpo = today.pointForecast>
                    <#assign tope = tomorrow.periodForecast>
                    <#assign topo = tomorrow.pointForecast>
                    <#assign thpe = thedayaftertomorrow.periodForecast>
                    <#assign thpo = thedayaftertomorrow.pointForecast>

                    <table class="dataTable">
                        <tr>
                            <td class="hourpres">
                                <#assign periodInfo>
                                    From: ${tpe.from.format('HH:mm')}<br/>
                                    To: ${tpe.to.format('dd-MM-yy HH:mm Z')}
                                </#assign>
                                <span onmouseover="tooltip.show('${periodInfo?html}', 200);" onmouseout="tooltip.hide();">
                                    <img src="/images/weather/${tpe.symbol.number}.png"/><br/>
                                </span>
                                <span class="hourdate">${tpo.from.format('dd-MM-yy')}</span><br/>
                                <span class="hourdate">${tpo.from.format('HH:mm')}</span><br/>
                                <span class="hourtemp">${tpo.temperature.value?string["0"]}&#8451;</span><br/>
                                <span class="hourpre">${tpe.precipitation.minValue?string["0.0"]} - ${tpe.precipitation.maxValue?string["0.0"]}mm</span><br
                                <img src="/images/wind/${tpo.windDirection.name?lower_case}${tpo.windSpeed.beaufort?string["0"]}.png"/>
                                <span class="hourdate">${tpo.windDirection.name} (${tpo.windDirection.deg})</span><br/>
                            </td>
                            <td class="hourpres">
                                <#assign periodInfo>
                                    From: ${tope.from}
                                    <br/>
                                    To: ${tope.to.format('dd-MM-yy HH:mm Z')}
                                </#assign>
                                <span onmouseover="tooltip.show('${periodInfo?html}', 200);" onmouseout="tooltip.hide();">
                                    <img src="/images/weather/${tope.symbol.number}.png"/><br/>
                                </span>
                                <span class="hourdate">${topo.from.format('dd-MM-yy')}</span><br/>
                                <span class="hourdate">${topo.from.format('HH:mm')}</span><br/>
                                <span class="hourtemp">${topo.temperature.value?string["0"]}&#8451;</span><br/>
                                <span class="hourpre">${tope.precipitation.minValue?string["0.0"]} - ${tope.precipitation.maxValue?string["0.0"]}mm</span><br/>
                                <img src="/images/wind/${topo.windDirection.name?lower_case}${topo.windSpeed.beaufort?string["00"]}.png"/>
                                <span class="hourdate">${topo.windDirection.name} (${topo.windDirection.deg})</span><br/>
                            </td>
                            <td class="hourpres">
                                <#assign periodInfo>
                                    From:${thpe.from.format('dd-MM-yy HH:mm Z')}<br/>
                                    To:${thpe.to.format('dd-MM-yy HH:mm Z')}
                                </#assign>
                                <span onmouseover="tooltip.show('${periodInfo?html}', 200);" onmouseout="tooltip.hide();">
                                    <img src="/images/weather/${thpe.symbol.number}.png"/><br/>
                                </span>
                                <span class="hourdate">
                                    ${thpo.from.format('dd-MM-yy')}
                                </span>
                                <br/>
                                <span class="hourdate">
                                    ${thpo.from.format('HH:mm')}
                                </span>
                                <br/>
                                <span class="hourtemp">
                                    ${thpo.temperature.value?string["0"]}&#8451;
                                </span>
                                <br/>
                                <span class="hourpre">
                                    ${thpe.precipitation.minValue?string["0.0"]} - ${thpe.precipitation.maxValue?string["0.0"]}mm
                                </span>
                                <br/>
                                <img src="/images/wind/${thpo.windDirection.name?lower_case}${thpo.windSpeed.beaufort?string["00"]}.png""/>
                                <span class="hourdate">
                                    ${thpo.windDirection.name} (${thpo.windDirection.deg})
                                </span>
                                <br/>
                            </td>
                        </tr>
                    </table>


                    <h3>Created</h3>

                    <p>${data.created}</p>

                    <h3>License</h3>

                    <p>${data.meta.licenseUrl!"No license found in source"}</p>

                    <h3>Models</h3>
                    <table class="dataTable">
                        <tr>
                            <th>name</th>
                            <th>to</th>
                            <th>from</th>
                            <th>runEnded</th>
                            <th>nextRun</th>
                            <th>termin</th>
                        </tr>
                        <#list data.meta.models as model>
                            <tr>
                                <td>${model.name}</td>
                                <td>${model.to}</td>
                                <td>${model.from}</td>
                                <td>${model.runEnded}</td>
                                <td>${model.nextRun}</td>
                                <td>${model.termin}</td>
                            </tr>
                        </#list>
                    </table>
                    <h3>Location</h3>
                    <table class="dataTable">
                        <tr>
                            <th>Longitude</th>
                            <th>Latitude</th>
                            <th>Altitude</th>
                        </tr>
                        <tr>
                            <td>${data.location.longitude}</td>
                            <td>${data.location.latitude}</td>
                            <td>${data.location.altitude}</td>
                        </tr>
                    </table>


                </div>
                <div role="tabpanel" class="tab-pane fade" id="data" aria-labelledBy="data-tab">
                    <h3>Raw data from MET</h3>
                    <pre><code class="xml">${raw?html}</code></pre>
                </div>
            </div>

        </#if>
        </div>
    </div>
</div>

<#include "footer.ftl">
