/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.locationforecast.LocationForecast;
import no.api.meteo.entity.core.service.locationforecast.PeriodForecast;
import no.api.meteo.entity.core.service.locationforecast.PointForecast;
import no.api.meteo.entity.extras.MeteoExtrasForecast;
import no.api.meteo.entity.extras.MeteoExtrasForecastDay;
import no.api.meteo.service.locationforecast.LocationforecastLTSService;
import no.api.meteo.service.locationforecast.extras.LocationForecastHelper;
import no.api.meteo.util.MeteoDateUtils;

public class LongTermForecastExample {
    public static final double LONGITUDE_BERGEN = 5.32;
    public static final double LATITUDE_BERGEN = 60.39;
    public static final int ALTITUDE_BERGEN = 3;
    private final MeteoClient meteoClient = new DefaultMeteoClient();

    public void runExample() {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        LocationforecastLTSService ltsService = new LocationforecastLTSService(this.meteoClient);
        try {
            MeteoData data = ltsService.fetchContent(5.32, 60.39, 3);
            LocationForecastHelper locationForecastHelper = new LocationForecastHelper((LocationForecast)data.getResult());
            for (MeteoExtrasForecastDay day : locationForecastHelper.createLongTermForecast().getForecastDays()) {
                this.print("\nDATE : " + day.getDay());
                for (MeteoExtrasForecast forecast : day.getForecasts()) {
                    PeriodForecast p = forecast.getPeriodForecast();
                    PointForecast po = forecast.getPointForecast();
                    ZonedDateTime df = MeteoDateUtils.cloneZonedDateTime((ZonedDateTime)p.getFrom());
                    ZonedDateTime dt = MeteoDateUtils.cloneZonedDateTime((ZonedDateTime)p.getTo());
                    this.print(df.format(fmt) + "-" + dt.format(fmt) + " | " + p.getSymbol().getId() + " | " + Math.round(po.getTemperature().getValue()) + " | " + p.getPrecipitation().getMinValue() + "-" + p.getPrecipitation().getMaxValue() + "," + p.getPrecipitation().getValue());
                }
            }
        }
        catch (MeteoException e) {
            this.print("Caught exception : " + e.getMessage());
        }
    }

    public void print(String s) {
        System.out.println(s);
    }

    public void shutDown() {
        this.meteoClient.shutdown();
    }

    public static void main(String[] args) {
        LongTermForecastExample longTermForecastExample = new LongTermForecastExample();
        longTermForecastExample.runExample();
        longTermForecastExample.shutDown();
    }
}

