/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.examples;

import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.textforecast.Time;
import no.api.meteo.entity.core.service.textforecast.Weather;
import no.api.meteo.entity.core.service.textforecast.query.ForecastQuery;
import no.api.meteo.service.textforecast.TextforecastService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextforecastExample {
    private static final Logger log = LoggerFactory.getLogger(TextforecastExample.class);
    private final MeteoClient meteoClient = new DefaultMeteoClient();

    public MeteoData<Weather> runExample() throws MeteoException {
        TextforecastService service = new TextforecastService(this.meteoClient);
        return service.fetchContent(ForecastQuery.LAND_NB);
    }

    public void shutDown() {
        this.meteoClient.shutdown();
    }

    public static void main(String[] args) throws MeteoException {
        TextforecastExample example = new TextforecastExample();
        MeteoData<Weather> data = example.runExample();
        log.info("Textforecast for %", (Object)((Weather)data.getResult()).getTitle());
        for (Time time : ((Weather)data.getResult()).getTimes()) {
            log.info(time.toString());
        }
        example.shutDown();
    }
}

