/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.spark;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import no.api.meteo.MeteoException;
import no.api.meteo.client.DefaultMeteoClient;
import no.api.meteo.client.MeteoClient;
import no.api.meteo.client.MeteoData;
import no.api.meteo.entity.core.service.locationforecast.LocationForecast;
import no.api.meteo.service.locationforecast.LocationforecastLTSService;
import no.api.meteo.service.locationforecast.extras.LocationForecastHelper;
import no.api.meteo.spark.FreeMarkerTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ModelAndView;
import spark.Request;
import spark.Spark;
import spark.SparkBase;
import spark.TemplateEngine;

public class DemoServer {
    private static final Logger log = LoggerFactory.getLogger(DemoServer.class);
    private static final MeteoClient METEO_CLIENT = new DefaultMeteoClient();

    public static void main(String[] args) {
        SparkBase.staticFileLocation((String)"/public");
        SparkBase.port((int)9090);
        Spark.get((String)"/", (req, rest) -> {
            HashMap attributes = new HashMap();
            return new ModelAndView(attributes, "index");
        }, (TemplateEngine)new FreeMarkerTemplateEngine());
        Spark.get((String)"/location", (req, rest) -> {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (req.queryParams("issearch") != null && req.queryParams("issearch").equals("true")) {
                DemoServer.prepareLocationResult(req, attributes);
            } else {
                attributes.put("search", false);
            }
            return new ModelAndView(attributes, "location");
        }, (TemplateEngine)new FreeMarkerTemplateEngine());
    }

    private static void prepareLocationResult(Request req, Map<String, Object> attributes) {
        attributes.put("search", true);
        String p = req.queryParams("p");
        attributes.put("p", p == null ? "0" : p);
        attributes.put("longitude", req.queryParams("longitude"));
        attributes.put("latitude", req.queryParams("latitude"));
        attributes.put("altitude", req.queryParams("altitude"));
        try {
            Optional afterForecast;
            Optional tomorrowForecast;
            MeteoData<LocationForecast> meteoData = DemoServer.fetchLocationForecast(req);
            attributes.put("data", meteoData.getResult());
            attributes.put("raw", meteoData.getResponse().getData());
            LocationForecastHelper helper = new LocationForecastHelper((LocationForecast)meteoData.getResult());
            attributes.put("last24", helper.findHourlyPointForecastsFromNow(24));
            ZonedDateTime firstDate = ZonedDateTime.now(ZoneId.of("Z")).withHour(12).withMinute(0).withSecond(0);
            Optional todayForecast = helper.findNearestForecast(firstDate);
            if (todayForecast.isPresent()) {
                attributes.put("today", todayForecast.get());
            }
            if ((tomorrowForecast = helper.findNearestForecast(firstDate.plusDays(1L))).isPresent()) {
                attributes.put("tomorrow", tomorrowForecast.get());
            }
            if ((afterForecast = helper.findNearestForecast(firstDate.plusDays(2L))).isPresent()) {
                attributes.put("thedayaftertomorrow", afterForecast.get());
            }
        }
        catch (MeteoException e) {
            log.error("Caught exception", (Throwable)e);
        }
    }

    private static MeteoData<LocationForecast> fetchLocationForecast(Request req) throws MeteoException {
        LocationforecastLTSService service = new LocationforecastLTSService(METEO_CLIENT);
        return service.fetchContent(Double.valueOf(req.queryParams("longitude")).doubleValue(), Double.valueOf(req.queryParams("latitude")).doubleValue(), Integer.valueOf(req.queryParams("altitude")).intValue());
    }
}

