/*
 * Decompiled with CFR 0.152.
 */
package no.api.meteo.spark;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.ZoneId;
import java.util.TimeZone;
import no.api.freemarker.java8.Java8ObjectWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ModelAndView;
import spark.TemplateEngine;

public class FreeMarkerTemplateEngine
extends TemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(FreeMarkerTemplateEngine.class);
    private final Configuration configuration = this.createFreeMarkerConfiguration();

    public String render(ModelAndView modelAndView) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = this.configuration.getTemplate(modelAndView.getViewName() + ".ftl");
            template.process(modelAndView.getModel(), (Writer)stringWriter);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Configuration createFreeMarkerConfiguration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        configuration.setTimeZone(TimeZone.getTimeZone(ZoneId.of("Europe/Oslo")));
        configuration.setClassForTemplateLoading(FreeMarkerTemplateEngine.class, "/");
        configuration.setObjectWrapper((ObjectWrapper)new Java8ObjectWrapper(Configuration.VERSION_2_3_23));
        return configuration;
    }
}

