/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtils {
    private static final DocumentBuilderFactory documentBuilderFactory;
    private static final TransformerFactory transformerFactory;

    private DomUtils() {
    }

    public static Document newEmptyXmlDocument() {
        try {
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to create new Document. ", e);
        }
    }

    public static Stream<Node> allNodesBelow(Node node) {
        try {
            NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(". | .//node() | .//@*", node, XPathConstants.NODESET);
            return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("allNodesBelow failed!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeToXml(Node root) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(root), new StreamResult(outputStream));
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException | TransformerException e) {
            throw new IllegalStateException("Unable to serialize XML", e);
        }
    }

    static {
        transformerFactory = TransformerFactory.newInstance();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
    }
}

