/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestOutputStream;
import java.util.zip.ZipEntry;
import no.difi.asic.AbstractAsicManifest;
import no.difi.asic.AsicOutputStream;
import no.difi.asic.AsicUtils;
import no.difi.asic.AsicWriter;
import no.difi.asic.CadesAsicWriter;
import no.difi.asic.MimeType;
import no.difi.asic.OasisManifest;
import no.difi.asic.SignatureHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAsicWriter
implements AsicWriter {
    public static final Logger log = LoggerFactory.getLogger(AbstractAsicWriter.class);
    protected AsicOutputStream asicOutputStream;
    protected AbstractAsicManifest asicManifest;
    protected boolean finished = false;
    protected OutputStream containerOutputStream = null;
    protected boolean closeStreamOnClose = false;
    protected OasisManifest oasisManifest = null;

    public AbstractAsicWriter(OutputStream outputStream, boolean closeStreamOnClose, AbstractAsicManifest asicManifest) throws IOException {
        this.containerOutputStream = outputStream;
        this.closeStreamOnClose = closeStreamOnClose;
        this.asicManifest = asicManifest;
        this.asicOutputStream = new AsicOutputStream(outputStream);
        this.oasisManifest = new OasisManifest(MimeType.forString("application/vnd.etsi.asic-e+zip"));
    }

    @Override
    public AsicWriter add(File file) throws IOException {
        return this.add(file.toPath());
    }

    @Override
    public AsicWriter add(File file, String entryName) throws IOException {
        return this.add(file.toPath(), entryName);
    }

    @Override
    public AsicWriter add(Path path) throws IOException {
        return this.add(path, path.toFile().getName());
    }

    @Override
    public AsicWriter add(Path path, String entryName) throws IOException {
        this.testExtension(path.toString());
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        this.add(inputStream, entryName);
        inputStream.close();
        return this;
    }

    @Override
    public AsicWriter add(InputStream inputStream, String filename) throws IOException {
        String mimeType = Files.probeContentType(Paths.get(filename, new String[0]));
        if (mimeType == null) {
            CadesAsicWriter.log.info("Unable to determine MIME type using Files.probeContentType(), trying URLConnection.getFileNameMap()");
            mimeType = URLConnection.getFileNameMap().getContentTypeFor(filename);
        }
        if (mimeType == null) {
            throw new IllegalStateException(String.format("Unable to determine MIME type of %s", filename));
        }
        return this.add(inputStream, filename, MimeType.forString(mimeType));
    }

    @Override
    public AsicWriter add(File file, String entryName, MimeType mimeType) throws IOException {
        return this.add(file.toPath(), entryName, mimeType);
    }

    @Override
    public AsicWriter add(Path path, String entryName, MimeType mimeType) throws IOException {
        this.testExtension(path.toString());
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        this.add(inputStream, entryName, mimeType);
        inputStream.close();
        return this;
    }

    @Override
    public AsicWriter add(InputStream inputStream, String filename, MimeType mimeType) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("Adding content to container after signing container is not supported.");
        }
        if (filename.startsWith("META-INF/")) {
            throw new IllegalStateException("Adding files to META-INF is not allowed.");
        }
        log.debug(String.format("Writing file %s to container", filename));
        this.asicOutputStream.putNextEntry(new ZipEntry(filename));
        DigestOutputStream zipOutputStreamWithDigest = new DigestOutputStream(this.asicOutputStream, this.asicManifest.getMessageDigest());
        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStreamWithDigest);
        zipOutputStreamWithDigest.flush();
        this.asicOutputStream.closeEntry();
        this.asicManifest.add(filename, mimeType);
        this.oasisManifest.add(filename, mimeType);
        return this;
    }

    @Override
    public AsicWriter sign(File keyStoreFile, String keyStorePassword, String keyPassword) throws IOException {
        return this.sign(keyStoreFile, keyStorePassword, null, keyPassword);
    }

    @Override
    public AbstractAsicWriter sign(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException {
        return this.sign(new SignatureHelper(keyStoreFile, keyStorePassword, keyAlias, keyPassword));
    }

    @Override
    public AbstractAsicWriter sign(SignatureHelper signatureHelper) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("Adding content to container after signing container is not supported.");
        }
        this.finished = true;
        this.performSign(signatureHelper);
        this.asicOutputStream.writeZipEntry("META-INF/manifest.xml", this.oasisManifest.toBytes());
        try {
            this.asicOutputStream.finish();
            this.asicOutputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to finish the container: %s", e.getMessage()), e);
        }
        if (this.closeStreamOnClose) {
            try {
                this.containerOutputStream.flush();
                this.containerOutputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to close file: %s", e.getMessage()), e);
            }
        }
        return this;
    }

    abstract void performSign(SignatureHelper var1) throws IOException;

    void testExtension(String extension) {
        if (!AsicUtils.PATTERN_EXTENSION_ASICE.matcher(extension).matches()) {
            log.warn("ASiC-E files should use \"asice\" as file extension.");
        }
    }

    public AbstractAsicManifest getAsicManifest() {
        return this.asicManifest;
    }
}

