/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import no.difi.asic.AsicReader;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.SignatureMethod;

public class AsicReaderFactory {
    private MessageDigestAlgorithm messageDigestAlgorithm;

    public static AsicReaderFactory newFactory() {
        return AsicReaderFactory.newFactory(MessageDigestAlgorithm.SHA256);
    }

    public static AsicReaderFactory newFactory(SignatureMethod signatureMethod) {
        return AsicReaderFactory.newFactory(signatureMethod.getMessageDigestAlgorithm());
    }

    static AsicReaderFactory newFactory(MessageDigestAlgorithm messageDigestAlgorithm) {
        return new AsicReaderFactory(messageDigestAlgorithm);
    }

    private AsicReaderFactory(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public AsicReader open(File file) throws IOException {
        return this.open(file.toPath());
    }

    public AsicReader open(Path file) throws IOException {
        return this.open(Files.newInputStream(file, new OpenOption[0]));
    }

    public AsicReader open(InputStream inputStream) throws IOException {
        return new AsicReader(this.messageDigestAlgorithm, inputStream);
    }
}

