/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import no.difi.asic.AbstractAsicWriter;
import no.difi.asic.AsicWriter;
import no.difi.asic.CadesAsicManifest;
import no.difi.asic.SignatureHelper;
import no.difi.asic.SignatureMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CadesAsicWriter
extends AbstractAsicWriter {
    public static final Logger log = LoggerFactory.getLogger(CadesAsicWriter.class);

    public CadesAsicWriter(SignatureMethod signatureMethod, OutputStream outputStream, boolean closeStreamOnClose) throws IOException {
        super(outputStream, closeStreamOnClose, new CadesAsicManifest(signatureMethod.getMessageDigestAlgorithm()));
    }

    @Override
    public AsicWriter setRootEntryName(String name) {
        ((CadesAsicManifest)this.asicManifest).setRootfileForEntry(name);
        return this;
    }

    @Override
    protected void performSign(SignatureHelper signatureHelper) throws IOException {
        String signatureFilename = String.format("META-INF/signature-%s.p7s", UUID.randomUUID().toString());
        ((CadesAsicManifest)this.asicManifest).setSignature(signatureFilename, "application/x-pkcs7-signature");
        byte[] manifestBytes = ((CadesAsicManifest)this.asicManifest).toBytes();
        this.asicOutputStream.writeZipEntry("META-INF/asicmanifest.xml", manifestBytes);
        this.asicOutputStream.writeZipEntry(signatureFilename, signatureHelper.signData(manifestBytes));
    }
}

