/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHelper {
    private static final Logger log = LoggerFactory.getLogger(SignatureHelper.class);
    private static JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC");
    private static JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider("BC");
    private X509Certificate x509Certificate;
    private Certificate[] certificateChain;
    private KeyPair keyPair;
    private JcaContentSignerBuilder jcaContentSignerBuilder;

    public SignatureHelper(File keyStoreFile, String keyStorePassword, String keyPassword) throws IOException {
        this(keyStoreFile, keyStorePassword, null, keyPassword);
    }

    public SignatureHelper(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException {
        this(Files.newInputStream(keyStoreFile.toPath(), new OpenOption[0]), keyStorePassword, keyAlias, keyPassword);
    }

    public SignatureHelper(InputStream keyStoreStream, String keyStorePassword, String keyAlias, String keyPassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, keyStorePassword.toCharArray());
            keyStoreStream.close();
            if (keyAlias == null) {
                keyAlias = keyStore.aliases().nextElement();
            }
            this.x509Certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
            this.certificateChain = keyStore.getCertificateChain(keyAlias);
            Key key = keyStore.getKey(keyAlias, keyPassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)key;
            this.keyPair = new KeyPair(this.x509Certificate.getPublicKey(), privateKey);
            this.jcaContentSignerBuilder = new JcaContentSignerBuilder(String.format("SHA1with%s", privateKey.getAlgorithm())).setProvider("BC");
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to retrieve private key from keystore: %s", e.getMessage()), e);
        }
    }

    byte[] signData(byte[] data) {
        try {
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderBuilder.build();
            ContentSigner contentSigner = this.jcaContentSignerBuilder.build(this.keyPair.getPrivate());
            SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider).build(contentSigner, this.x509Certificate);
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            cmsSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            cmsSignedDataGenerator.addCertificates((Store)new JcaCertStore(Arrays.asList(this.x509Certificate)));
            CMSSignedData cmsSignedData = cmsSignedDataGenerator.generate((CMSTypedData)new CMSProcessableByteArray(data), false);
            log.debug(new String(Base64.encodeBase64((byte[])cmsSignedData.getEncoded())));
            return cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to sign " + e.getMessage(), e);
        }
    }

    static no.difi.xsd.asic.model._1.Certificate validate(byte[] data, byte[] signature) {
        no.difi.xsd.asic.model._1.Certificate certificate = null;
        try {
            CMSSignedData cmsSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), signature);
            Store store = cmsSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cmsSignedData.getSignerInfos();
            for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
                X509CertificateHolder x509Certificate = (X509CertificateHolder)store.getMatches((Selector)signerInformation.getSID()).iterator().next();
                log.info(x509Certificate.getSubject().toString());
                if (!signerInformation.verify(jcaSimpleSignerInfoVerifierBuilder.build(x509Certificate))) continue;
                certificate = new no.difi.xsd.asic.model._1.Certificate();
                certificate.setCertificate(x509Certificate.getEncoded());
                certificate.setSubject(x509Certificate.getSubject().toString());
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            certificate = null;
        }
        if (certificate == null) {
            throw new IllegalStateException("Unable to verify signature.");
        }
        return certificate;
    }

    X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

