/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsicInputStream
extends ZipInputStream {
    public static final Logger log = LoggerFactory.getLogger(AsicInputStream.class);

    public AsicInputStream(InputStream in) {
        super(in);
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        ZipEntry zipEntry = super.getNextEntry();
        if (zipEntry != null && zipEntry.getName().equals("mimetype")) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)this, (OutputStream)baos);
            log.debug(String.format("Content of mimetype: %s", baos.toString()));
            if (!"application/vnd.etsi.asic-e+zip".equals(baos.toString())) {
                throw new IllegalStateException("Content is not ASiC-E container.");
            }
            zipEntry = super.getNextEntry();
        }
        return zipEntry;
    }
}

