/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import no.difi.asic.AsicInputStream;
import no.difi.asic.AsicOutputStream;
import no.difi.asic.CadesAsicManifest;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MimeType;
import no.difi.asic.OasisManifest;
import org.apache.commons.io.IOUtils;

public class AsicUtils {
    public static final String MIMETYPE_ASICE = "application/vnd.etsi.asic-e+zip";
    static final Pattern PATTERN_CADES_MANIFEST = Pattern.compile("META-INF/asicmanifest(.*)\\.xml", 2);
    static final Pattern PATTERN_CADES_SIGNATURE = Pattern.compile("META-INF/signature(.*)\\.p7s", 2);
    static final Pattern PATTERN_XADES_SIGNATURES = Pattern.compile("META-INF/signatures(.*)\\.xml", 2);
    static final Pattern PATTERN_EXTENSION_ASICE = Pattern.compile(".+\\.(asice|sce)", 2);

    AsicUtils() {
    }

    public static void combine(OutputStream outputStream, InputStream ... inputStreams) throws IOException {
        int manifestCounter = 0;
        int fileCounter = 0;
        boolean containsRootFile = false;
        AsicOutputStream target = new AsicOutputStream(outputStream);
        OasisManifest oasisManifest = new OasisManifest(MimeType.forString(MIMETYPE_ASICE));
        for (InputStream inputStream : inputStreams) {
            ZipEntry zipEntry;
            AsicInputStream source = new AsicInputStream(inputStream);
            while ((zipEntry = source.getNextEntry()) != null) {
                ByteArrayOutputStream byteArrayOutputStream;
                if (PATTERN_CADES_MANIFEST.matcher(zipEntry.getName()).matches()) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)source, (OutputStream)byteArrayOutputStream);
                    ManifestVerifier manifestVerifier = new ManifestVerifier(null);
                    CadesAsicManifest.extractAndVerify(byteArrayOutputStream.toString(), manifestVerifier);
                    if (manifestVerifier.getAsicManifest().getRootfile() != null) {
                        if (containsRootFile) {
                            throw new IllegalStateException("Multiple rootfiles is not allowed when combining containers.");
                        }
                        containsRootFile = true;
                    }
                    target.putNextEntry(new ZipEntry(String.format("META-INF/asicmanifest%s.xml", ++manifestCounter)));
                    IOUtils.copy((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), (OutputStream)target);
                } else if (PATTERN_XADES_SIGNATURES.matcher(zipEntry.getName()).matches()) {
                    target.putNextEntry(new ZipEntry(String.format("META-INF/signatures%s.xml", ++manifestCounter)));
                    IOUtils.copy((InputStream)source, (OutputStream)target);
                } else {
                    if (zipEntry.getName().equals("META-INF/manifest.xml")) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)source, (OutputStream)byteArrayOutputStream);
                        oasisManifest.append(new OasisManifest(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
                        target.closeEntry();
                        continue;
                    }
                    target.putNextEntry(zipEntry);
                    IOUtils.copy((InputStream)source, (OutputStream)target);
                    if (!zipEntry.getName().startsWith("META-INF/")) {
                        ++fileCounter;
                    }
                }
                source.closeEntry();
                target.closeEntry();
            }
            source.close();
        }
        if (oasisManifest.size() == fileCounter + 1) {
            target.writeZipEntry("META-INF/manifest.xml", oasisManifest.toBytes());
        }
        target.close();
    }
}

