/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import no.difi.asic.AbstractAsicManifest;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.MimeType;
import no.difi.asic.SignatureHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.DataObjectFormat;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.QualifyingProperties;
import org.etsi.uri._01903.v1_3.SignedDataObjectProperties;
import org.etsi.uri._01903.v1_3.SignedProperties;
import org.etsi.uri._01903.v1_3.SignedSignatureProperties;
import org.etsi.uri._01903.v1_3.SigningCertificate;
import org.etsi.uri._02918.v1_2.XAdESSignatures;
import org.w3._2000._09.xmldsig_.CanonicalizationMethod;
import org.w3._2000._09.xmldsig_.DigestMethod;
import org.w3._2000._09.xmldsig_.KeyInfo;
import org.w3._2000._09.xmldsig_.Object;
import org.w3._2000._09.xmldsig_.ObjectFactory;
import org.w3._2000._09.xmldsig_.Reference;
import org.w3._2000._09.xmldsig_.Signature;
import org.w3._2000._09.xmldsig_.SignatureMethod;
import org.w3._2000._09.xmldsig_.SignatureValue;
import org.w3._2000._09.xmldsig_.SignedInfo;
import org.w3._2000._09.xmldsig_.Transform;
import org.w3._2000._09.xmldsig_.Transforms;
import org.w3._2000._09.xmldsig_.X509Data;
import org.w3._2000._09.xmldsig_.X509IssuerSerialType;

class XadesAsicManifest
extends AbstractAsicManifest {
    private static JAXBContext jaxbContext;
    private SignedInfo signedInfo;
    private SignedDataObjectProperties signedDataObjectProperties = new SignedDataObjectProperties();

    public XadesAsicManifest(MessageDigestAlgorithm messageDigestAlgorithm) {
        super(messageDigestAlgorithm);
        this.signedInfo = new SignedInfo();
        CanonicalizationMethod canonicalizationMethod = new CanonicalizationMethod();
        canonicalizationMethod.setAlgorithm("http://www.w3.org/2006/12/xml-c14n11");
        this.signedInfo.setCanonicalizationMethod(canonicalizationMethod);
        SignatureMethod signatureMethod = new SignatureMethod();
        signatureMethod.setAlgorithm(messageDigestAlgorithm.getUri());
        this.signedInfo.setSignatureMethod(signatureMethod);
    }

    @Override
    public void add(String filename, MimeType mimeType) {
        String id = String.format("ID_%s", this.signedInfo.getReferences().size());
        Reference reference = new Reference();
        reference.setId(id);
        reference.setURI(filename);
        reference.setDigestValue(this.messageDigest.digest());
        DigestMethod digestMethodType = new DigestMethod();
        digestMethodType.setAlgorithm(this.messageDigestAlgorithm.getUri());
        reference.setDigestMethod(digestMethodType);
        this.signedInfo.getReferences().add(reference);
        DataObjectFormat dataObjectFormatType = new DataObjectFormat();
        dataObjectFormatType.setObjectReference(String.format("#%s", id));
        dataObjectFormatType.setMimeType(mimeType.toString());
        this.signedDataObjectProperties.getDataObjectFormats().add(dataObjectFormatType);
    }

    XAdESSignatures getCreateXAdESSignatures(SignatureHelper signatureHelper) {
        XAdESSignatures xAdESSignaturesType = new XAdESSignatures();
        Signature signatureType = new Signature();
        signatureType.setId("Signature");
        signatureType.setSignedInfo(this.signedInfo);
        xAdESSignaturesType.getSignatures().add(signatureType);
        KeyInfo keyInfoType = new KeyInfo();
        keyInfoType.getContent().add(this.getX509Data(signatureHelper));
        signatureType.setKeyInfo(keyInfoType);
        Object objectType = new Object();
        objectType.getContent().add(this.getQualifyingProperties(signatureHelper));
        signatureType.getObjects().add(objectType);
        signatureType.setSignatureValue(this.getSignature());
        return xAdESSignaturesType;
    }

    public byte[] toBytes(SignatureHelper signatureHelper) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (java.lang.Object)Boolean.TRUE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((java.lang.Object)this.getCreateXAdESSignatures(signatureHelper), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to marshall the XAdESSignature into string output", e);
        }
    }

    private X509Data getX509Data(SignatureHelper signatureHelper) {
        ObjectFactory objectFactory = new ObjectFactory();
        X509Data x509DataType = new X509Data();
        for (Certificate certificate : signatureHelper.getCertificateChain()) {
            try {
                x509DataType.getX509IssuerSerialsAndX509SKISAndX509SubjectNames().add(objectFactory.createX509DataX509Certificate(certificate.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                throw new IllegalStateException("Unable to insert certificate.", e);
            }
        }
        return x509DataType;
    }

    private QualifyingProperties getQualifyingProperties(SignatureHelper signatureHelper) {
        SignedSignatureProperties signedSignaturePropertiesType = new SignedSignatureProperties();
        try {
            signedSignaturePropertiesType.setSigningTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Unable to use current DatatypeFactory", e);
        }
        SigningCertificate signingCertificate = new SigningCertificate();
        signedSignaturePropertiesType.setSigningCertificate(signingCertificate);
        CertIDType cert = new CertIDType();
        signingCertificate.getCerts().add(cert);
        try {
            DigestAlgAndValueType certDigest = new DigestAlgAndValueType();
            certDigest.setDigestValue(DigestUtils.sha1((byte[])signatureHelper.getX509Certificate().getEncoded()));
            cert.setCertDigest(certDigest);
            DigestMethod digestMethodType = new DigestMethod();
            digestMethodType.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            certDigest.setDigestMethod(digestMethodType);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Unable to encode certificate.", e);
        }
        X509IssuerSerialType issuerSerialType = new X509IssuerSerialType();
        issuerSerialType.setX509IssuerName(signatureHelper.getX509Certificate().getIssuerX500Principal().getName());
        issuerSerialType.setX509SerialNumber(signatureHelper.getX509Certificate().getSerialNumber());
        cert.setIssuerSerial(issuerSerialType);
        SignedProperties signedPropertiesType = new SignedProperties();
        signedPropertiesType.setId("SignedProperties");
        signedPropertiesType.setSignedSignatureProperties(signedSignaturePropertiesType);
        signedPropertiesType.setSignedDataObjectProperties(this.signedDataObjectProperties);
        QualifyingProperties qualifyingPropertiesType = new QualifyingProperties();
        qualifyingPropertiesType.setSignedProperties(signedPropertiesType);
        qualifyingPropertiesType.setTarget("#Signature");
        Reference reference = new Reference();
        reference.setType("http://uri.etsi.org/01903#SignedProperties");
        reference.setURI("#SignedProperties");
        Transforms transformsType = new Transforms();
        reference.setTransforms(transformsType);
        Transform transformType = new Transform();
        transformType.setAlgorithm("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        reference.getTransforms().getTransforms().add(transformType);
        DigestMethod digestMethodType = new DigestMethod();
        digestMethodType.setAlgorithm(this.messageDigestAlgorithm.getUri());
        reference.setDigestMethod(digestMethodType);
        this.signedInfo.getReferences().add(reference);
        return qualifyingPropertiesType;
    }

    protected SignatureValue getSignature() {
        SignatureValue signatureValue = new SignatureValue();
        return signatureValue;
    }

    public static void extractAndVerify(String xml, ManifestVerifier manifestVerifier) {
        XAdESSignatures manifest;
        xml = xml.replace("http://uri.etsi.org/02918/v1.1.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replace("http://uri.etsi.org/2918/v1.2.1#", "http://uri.etsi.org/02918/v1.2.1#");
        xml = xml.replaceAll("http://www.w3.org/2000/09/xmldsig#sha", "http://www.w3.org/2001/04/xmlenc#sha");
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            manifest = (XAdESSignatures)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read content as XML", e);
        }
        for (Signature signature : manifest.getSignatures()) {
            SignedInfo signedInfoType = signature.getSignedInfo();
            for (Reference reference : signedInfoType.getReferences()) {
                if (reference.getURI().startsWith("#")) continue;
                manifestVerifier.update(reference.getURI(), null, reference.getDigestValue(), reference.getDigestMethod().getAlgorithm(), null);
            }
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XAdESSignatures.class, X509Data.class, QualifyingProperties.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Unable to create JAXBContext: %s ", e.getMessage()), e);
        }
    }
}

