/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.io.IOException;
import java.io.OutputStream;
import no.difi.asic.AbstractAsicWriter;
import no.difi.asic.AsicWriter;
import no.difi.asic.SignatureHelper;
import no.difi.asic.SignatureMethod;
import no.difi.asic.XadesAsicManifest;

class XadesAsicWriter
extends AbstractAsicWriter {
    public XadesAsicWriter(SignatureMethod signatureMethod, OutputStream outputStream, boolean closeStreamOnClose) throws IOException {
        super(outputStream, closeStreamOnClose, new XadesAsicManifest(signatureMethod.getMessageDigestAlgorithm()));
    }

    @Override
    public AsicWriter setRootEntryName(String name) {
        throw new IllegalStateException("ASiC-E XAdES does not support defining root file.");
    }

    @Override
    void performSign(SignatureHelper signatureHelper) throws IOException {
        byte[] manifestBytes = ((XadesAsicManifest)this.asicManifest).toBytes(signatureHelper);
        this.asicOutputStream.writeZipEntry("META-INF/signatures.xml", manifestBytes);
    }
}

