/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.xsd.asic.model._1.AsicFile;
import no.difi.xsd.asic.model._1.AsicManifest;
import no.difi.xsd.asic.model._1.Certificate;

class ManifestVerifier {
    private MessageDigestAlgorithm messageDigestAlgorithm;
    private AsicManifest asicManifest = new AsicManifest();
    private Map<String, AsicFile> asicManifestMap = new HashMap<String, AsicFile>();

    public ManifestVerifier(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public void update(String filename, byte[] digest, String sigReference) {
        this.update(filename, null, digest, null, sigReference);
    }

    public void update(String filename, String mimetype, byte[] digest, String digestAlgorithm, String sigReference) {
        if (this.messageDigestAlgorithm != null && digestAlgorithm != null && !digestAlgorithm.equals(this.messageDigestAlgorithm.getUri())) {
            throw new IllegalStateException(String.format("Wrong digest method for file %s: %s", filename, digestAlgorithm));
        }
        AsicFile asicFile = this.asicManifestMap.get(filename);
        if (asicFile == null) {
            asicFile = new AsicFile();
            asicFile.setName(filename);
            asicFile.setDigest(digest);
            asicFile.setVerified(false);
            this.asicManifest.getFile().add(asicFile);
            this.asicManifestMap.put(filename, asicFile);
        } else {
            if (!Arrays.equals(asicFile.getDigest(), digest)) {
                throw new IllegalStateException(String.format("Mismatching digest for file %s", filename));
            }
            asicFile.setVerified(true);
        }
        if (mimetype != null) {
            asicFile.setMimetype(mimetype);
        }
        if (sigReference != null) {
            asicFile.getCertRef().add(sigReference);
        }
    }

    public void addCertificate(Certificate certificate) {
        this.asicManifest.getCertificate().add(certificate);
    }

    public void setRootFilename(String filename) {
        this.asicManifest.setRootfile(filename);
    }

    public void verifyAllVerified() {
        for (AsicFile asicFile : this.asicManifest.getFile()) {
            if (asicFile.isVerified()) continue;
            throw new IllegalStateException(String.format("File not verified: %s", asicFile.getName()));
        }
    }

    public AsicManifest getAsicManifest() {
        return this.asicManifest;
    }
}

