/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic.extras;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import no.difi.asic.AsicReader;
import no.difi.xsd.asic.model._1.AsicManifest;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CmsEncryptedAsicReader
implements AsicReader {
    private static final String BC = "BC";
    private AsicReader asicReader;
    private PrivateKey privateKey;
    private String currentFile;

    public CmsEncryptedAsicReader(AsicReader asicReader, PrivateKey privateKey) {
        this.asicReader = asicReader;
        this.privateKey = privateKey;
    }

    @Override
    public String getNextFile() throws IOException {
        this.currentFile = this.asicReader.getNextFile();
        if (this.currentFile == null) {
            return null;
        }
        return this.currentFile.endsWith(".p7m") ? this.currentFile.substring(0, this.currentFile.length() - 4) : this.currentFile;
    }

    @Override
    public void writeFile(File file) throws IOException {
        this.writeFile(file.toPath());
    }

    @Override
    public void writeFile(Path path) throws IOException {
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        this.writeFile(outputStream);
        outputStream.close();
    }

    @Override
    public void writeFile(OutputStream outputStream) throws IOException {
        if (this.currentFile.endsWith(".p7m")) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.asicReader.writeFile(byteArrayOutputStream);
                CMSEnvelopedDataParser cmsEnvelopedDataParser = new CMSEnvelopedDataParser((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                Collection recipients = cmsEnvelopedDataParser.getRecipientInfos().getRecipients();
                if (recipients.size() != 1) {
                    throw new IllegalArgumentException();
                }
                RecipientInformation recipient = (RecipientInformation)recipients.iterator().next();
                byte[] decryptedData = recipient.getContent((Recipient)new JceKeyTransEnvelopedRecipient(this.privateKey).setProvider(BC));
                ByteStreams.copy((InputStream)new ByteArrayInputStream(decryptedData), (OutputStream)outputStream);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        } else {
            this.asicReader.writeFile(outputStream);
        }
    }

    @Override
    public InputStream inputStream() throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        this.writeFile(pipedOutputStream);
        return pipedInputStream;
    }

    @Override
    public void close() throws IOException {
        this.asicReader.close();
    }

    @Override
    public AsicManifest getAsicManifest() {
        return this.asicReader.getAsicManifest();
    }

    static {
        if (Security.getProvider(BC) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

