/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import no.difi.asic.AsicInputStream;
import no.difi.asic.AsicUtils;
import no.difi.asic.CadesAsicManifest;
import no.difi.asic.InputStreamWrapper;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.OasisManifest;
import no.difi.asic.SignatureVerifier;
import no.difi.asic.XadesAsicManifest;
import no.difi.asic.zipbomb.MaxSizeProtectedOutputStream;
import no.difi.commons.asic.jaxb.asic.AsicManifest;
import no.difi.commons.asic.jaxb.asic.Certificate;
import no.difi.commons.asic.jaxb.opendocument.manifest.Manifest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAsicReader
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAsicReader.class);
    private MessageDigest messageDigest;
    private AsicInputStream zipInputStream;
    private ZipEntry currentZipEntry;
    private ManifestVerifier manifestVerifier;
    private Manifest manifest;
    private boolean contentIsWritten = true;
    private Map<String, Object> signingContent = new HashMap<String, Object>();

    AbstractAsicReader(MessageDigestAlgorithm messageDigestAlgorithm, InputStream inputStream) throws IOException {
        this.manifestVerifier = new ManifestVerifier(messageDigestAlgorithm);
        try {
            this.messageDigest = MessageDigest.getInstance(messageDigestAlgorithm.getAlgorithm());
            this.messageDigest.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Algorithm %s not supported", messageDigestAlgorithm.getAlgorithm()), e);
        }
        this.zipInputStream = new AsicInputStream(inputStream);
    }

    public String getNextFile() throws IOException {
        if (!this.contentIsWritten) {
            this.writeFile(ByteStreams.nullOutputStream());
        }
        if (this.currentZipEntry != null) {
            byte[] digest = this.messageDigest.digest();
            logger.debug("Digest: {}", (Object)Base64.encode((byte[])digest));
            this.manifestVerifier.update(this.currentZipEntry.getName(), digest, null);
        }
        while ((this.currentZipEntry = this.zipInputStream.getNextEntry()) != null) {
            logger.info("Found file: {}", (Object)this.currentZipEntry.getName());
            if (this.currentZipEntry.getName().startsWith("META-INF/")) {
                this.handleMetadataEntry();
                continue;
            }
            this.contentIsWritten = false;
            return this.currentZipEntry.getName();
        }
        this.manifestVerifier.verifyAllVerified();
        if (this.signingContent.size() > 0) {
            throw new IllegalStateException(String.format("Signature not verified: %s", this.signingContent.keySet().iterator().next()));
        }
        return null;
    }

    void writeFile(OutputStream outputStream) throws IOException {
        if (this.currentZipEntry == null) {
            throw new IllegalStateException("No file to read.");
        }
        this.messageDigest.reset();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream, this.messageDigest);
        ByteStreams.copy((InputStream)this.zipInputStream, (OutputStream)digestOutputStream);
        this.zipInputStream.closeEntry();
        this.contentIsWritten = true;
    }

    InputStream inputStream() {
        if (this.currentZipEntry == null) {
            throw new IllegalStateException("No file to read.");
        }
        this.contentIsWritten = true;
        this.messageDigest.reset();
        return new InputStreamWrapper(new DigestInputStream(this.zipInputStream, this.messageDigest));
    }

    @Override
    public void close() throws IOException {
        if (this.zipInputStream != null) {
            this.zipInputStream.close();
            this.zipInputStream = null;
        }
    }

    private void handleMetadataEntry() throws IOException {
        String filename = this.currentZipEntry.getName().substring(9).toLowerCase();
        MaxSizeProtectedOutputStream contentsOfStream = new MaxSizeProtectedOutputStream();
        ByteStreams.copy((InputStream)this.zipInputStream, (OutputStream)contentsOfStream);
        if (AsicUtils.PATTERN_CADES_MANIFEST.matcher(this.currentZipEntry.getName()).matches()) {
            String sigReference = CadesAsicManifest.extractAndVerify(contentsOfStream.toString(), this.manifestVerifier);
            this.handleCadesSigning(sigReference, contentsOfStream.toString());
        } else if (AsicUtils.PATTERN_XADES_SIGNATURES.matcher(this.currentZipEntry.getName()).matches()) {
            XadesAsicManifest.extractAndVerify(contentsOfStream.toString(), this.manifestVerifier);
        } else if (AsicUtils.PATTERN_CADES_SIGNATURE.matcher(this.currentZipEntry.getName()).matches()) {
            this.handleCadesSigning(this.currentZipEntry.getName(), contentsOfStream);
        } else if (filename.equals("manifest.xml")) {
            this.manifest = OasisManifest.read(new ByteArrayInputStream(contentsOfStream.toByteArray()));
        } else {
            throw new IllegalStateException(String.format("Contains unknown metadata file: %s", this.currentZipEntry.getName()));
        }
    }

    private void handleCadesSigning(String sigReference, Object o) {
        if (!this.signingContent.containsKey(sigReference)) {
            this.signingContent.put(sigReference, o);
        } else {
            byte[] data = o instanceof String ? ((String)o).getBytes() : ((String)this.signingContent.get(sigReference)).getBytes();
            byte[] sign = o instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)o).toByteArray() : ((ByteArrayOutputStream)this.signingContent.get(sigReference)).toByteArray();
            Certificate certificate = SignatureVerifier.validate(data, sign);
            certificate.setCert(this.currentZipEntry.getName());
            this.manifestVerifier.addCertificate(certificate);
            this.signingContent.remove(sigReference);
        }
    }

    public AsicManifest getAsicManifest() {
        return this.manifestVerifier.getAsicManifest();
    }

    public Manifest getOasisManifest() {
        return this.manifest;
    }
}

