/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import no.difi.asic.AbstractAsicManifest;
import no.difi.asic.CreateXadesArtifacts;
import no.difi.asic.DomUtils;
import no.difi.asic.ManifestVerifier;
import no.difi.asic.MessageDigestAlgorithm;
import no.difi.asic.MimeType;
import no.difi.asic.SignatureHelper;
import no.difi.asic.XadesArtifacts;
import no.difi.commons.asic.jaxb.cades.XAdESSignaturesType;
import no.difi.commons.asic.jaxb.xades.DataObjectFormatType;
import no.difi.commons.asic.jaxb.xades.QualifyingPropertiesType;
import no.difi.commons.asic.jaxb.xades.SignedDataObjectPropertiesType;
import no.difi.commons.asic.jaxb.xmldsig.ReferenceType;
import no.difi.commons.asic.jaxb.xmldsig.SignatureType;
import no.difi.commons.asic.jaxb.xmldsig.SignedInfoType;
import no.difi.commons.asic.jaxb.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XadesAsicManifest
extends AbstractAsicManifest {
    private static final String C14V1 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String ASIC_NAMESPACE = "http://uri.etsi.org/02918/v1.2.1#";
    private static final String SIGNED_PROPERTIES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    private static final JAXBContext jaxbContext;
    private static final CreateXadesArtifacts createXAdESArtifacts;
    private final XMLSignatureFactory xmlSignatureFactory;
    private final SignatureMethod signatureMethod;
    private final CanonicalizationMethod canonicalizationMethod;
    private final Transform canonicalXmlTransform;
    private final DigestMethod digestMethod;
    private final List<Reference> references = new ArrayList<Reference>();
    private final SignedDataObjectPropertiesType signedDataObjectProperties = new SignedDataObjectPropertiesType();

    public XadesAsicManifest(MessageDigestAlgorithm messageDigestAlgorithm) {
        super(messageDigestAlgorithm);
        this.xmlSignatureFactory = this.getSignatureFactory();
        this.signatureMethod = this.getSignatureMethod(this.xmlSignatureFactory);
        try {
            this.canonicalizationMethod = this.xmlSignatureFactory.newCanonicalizationMethod(C14V1, (C14NMethodParameterSpec)null);
            this.canonicalXmlTransform = this.xmlSignatureFactory.newTransform(C14V1, (TransformParameterSpec)null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Kunne ikke initialisere xml-signering", e);
        }
        this.digestMethod = this.getDigestMethod(messageDigestAlgorithm);
    }

    private XMLSignatureFactory getSignatureFactory() {
        try {
            return XMLSignatureFactory.getInstance("DOM", "XMLDSig");
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("Could not find provider for DOM:XMLDSig", e);
        }
    }

    private SignatureMethod getSignatureMethod(XMLSignatureFactory xmlSignatureFactory) {
        try {
            return xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not get signature method", e);
        }
    }

    private DigestMethod getDigestMethod(MessageDigestAlgorithm messageDigestAlgorithm) {
        try {
            return this.xmlSignatureFactory.newDigestMethod(messageDigestAlgorithm.getUri(), null);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not create DigestMethod!", e);
        }
    }

    @Override
    public void add(String filename, MimeType mimeType) {
        String id = String.format("ID_%s", this.references.size());
        this.references.add(this.xmlSignatureFactory.newReference(this.encodeFilename(filename), this.digestMethod, null, null, id, this.messageDigest.digest()));
        DataObjectFormatType dataObjectFormatType = new DataObjectFormatType();
        dataObjectFormatType.setObjectReference(String.format("#%s", id));
        dataObjectFormatType.setMimeType(mimeType.toString());
        this.signedDataObjectProperties.getDataObjectFormat().add(dataObjectFormatType);
    }

    private String encodeFilename(String filename) {
        try {
            return URLEncoder.encode(filename, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(String.format("Could not URL encode filename = '%s'", filename), e);
        }
    }

    public byte[] toBytes(SignatureHelper signatureHelper) {
        XadesArtifacts xadesArtifacts = createXAdESArtifacts.createArtifactsToSign(this.signedDataObjectProperties.getDataObjectFormat(), signatureHelper.getX509Certificate());
        this.references.add(this.xmlSignatureFactory.newReference(xadesArtifacts.getSignablePropertiesReferenceUri(), this.digestMethod, Collections.singletonList(this.canonicalXmlTransform), SIGNED_PROPERTIES_TYPE, null));
        KeyInfo keyInfo = this.keyInfo(signatureHelper.getCertificateChain());
        SignedInfo signedInfo = this.xmlSignatureFactory.newSignedInfo(this.canonicalizationMethod, this.signatureMethod, this.references);
        XMLObject xmlObject = this.xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(xadesArtifacts.getDocument().getDocumentElement())), null, null, null);
        XMLSignature xmlSignature = this.xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xmlObject), "Signature", null);
        Document signedDocument = DomUtils.newEmptyXmlDocument();
        DOMSignContext signContext = new DOMSignContext(signatureHelper.keyPair.getPrivate(), (Node)XadesAsicManifest.addXAdESSignaturesElement(signedDocument));
        signContext.setURIDereferencer(this.signedPropertiesURIDereferencer(xadesArtifacts));
        try {
            xmlSignature.sign(signContext);
        }
        catch (MarshalException e) {
            throw new IllegalStateException("Could not marshal ASiC-E signature.xml", e);
        }
        catch (XMLSignatureException e) {
            throw new IllegalStateException("Could not sign ASiC-E", e);
        }
        return DomUtils.serializeToXml(signedDocument);
    }

    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    private URIDereferencer signedPropertiesURIDereferencer(XadesArtifacts xadesArtifacts) {
        return (uriReference, context) -> {
            if (xadesArtifacts.getSignablePropertiesReferenceUri().equals(uriReference.getURI())) {
                return DomUtils.allNodesBelow(xadesArtifacts.getSignableProperties())::iterator;
            }
            return this.xmlSignatureFactory.getURIDereferencer().dereference(uriReference, context);
        };
    }

    private static Element addXAdESSignaturesElement(Document doc) {
        return (Element)doc.appendChild(doc.createElementNS(ASIC_NAMESPACE, "XAdESSignatures"));
    }

    private KeyInfo keyInfo(Certificate[] sertifikater) {
        KeyInfoFactory keyInfoFactory = this.xmlSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Arrays.asList(sertifikater));
        return keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
    }

    public static void extractAndVerify(String xml, ManifestVerifier manifestVerifier) {
        XAdESSignaturesType manifest;
        xml = xml.replace("http://uri.etsi.org/02918/v1.1.1#", ASIC_NAMESPACE).replace("http://uri.etsi.org/2918/v1.2.1#", ASIC_NAMESPACE).replaceAll("http://www.w3.org/2000/09/xmldsig#sha", "http://www.w3.org/2001/04/xmlenc#sha");
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            manifest = (XAdESSignaturesType)unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(xml.getBytes())), XAdESSignaturesType.class).getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read content as XML", e);
        }
        for (SignatureType signature : manifest.getSignature()) {
            SignedInfoType signedInfoType = signature.getSignedInfo();
            for (ReferenceType reference : signedInfoType.getReference()) {
                if (reference.getURI().startsWith("#")) continue;
                manifestVerifier.update(reference.getURI(), null, reference.getDigestValue(), reference.getDigestMethod().getAlgorithm(), null);
            }
        }
    }

    static {
        createXAdESArtifacts = new CreateXadesArtifacts();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XAdESSignaturesType.class, X509DataType.class, QualifyingPropertiesType.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException(String.format("Unable to create JAXBContext: %s ", e.getMessage()), e);
        }
    }
}

