/*
 * Decompiled with CFR 0.152.
 */
package no.difi.asic.zipbomb;

import java.io.ByteArrayOutputStream;

public class MaxSizeProtectedOutputStream
extends ByteArrayOutputStream {
    private final long MAX_SIZE_DECOMPRESSED;

    public MaxSizeProtectedOutputStream() {
        this(0x100000L);
    }

    public MaxSizeProtectedOutputStream(long maxSize) {
        this.MAX_SIZE_DECOMPRESSED = maxSize;
        if (maxSize < 1024L) {
            throw new IllegalArgumentException("Max size should be at least 1 KiB");
        }
    }

    @Override
    public void write(int b) {
        super.write(b);
        if ((long)this.count > this.MAX_SIZE_DECOMPRESSED) {
            this.throwSizeLimitExceeded(this.count);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        if ((long)this.count > this.MAX_SIZE_DECOMPRESSED) {
            this.throwSizeLimitExceeded(this.count);
        }
    }

    private void throwSizeLimitExceeded(long size) {
        throw new RuntimeException("Output exceeds max configured size of " + this.MAX_SIZE_DECOMPRESSED + ", aborted after " + size + " bytes");
    }
}

