/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
implements ValidatorRule {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    private static CertificateFactory certFactory;
    private ValidatorRule validatorRule;

    public static X509Certificate getCertificate(byte[] cert) throws CertificateValidationException {
        return Validator.getCertificate(new ByteArrayInputStream(cert));
    }

    public static X509Certificate getCertificate(InputStream inputStream) throws CertificateValidationException {
        try {
            if (certFactory == null) {
                certFactory = CertificateFactory.getInstance("X.509");
            }
            return (X509Certificate)certFactory.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }

    public Validator(ValidatorRule validatorRule) {
        this.validatorRule = validatorRule;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        this.validatorRule.validate(certificate);
    }

    public X509Certificate validate(InputStream inputStream) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(inputStream);
        this.validate(certificate);
        return certificate;
    }

    public X509Certificate validate(byte[] bytes) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(bytes);
        this.validate(certificate);
        return certificate;
    }

    public boolean isValid(X509Certificate certificate) {
        try {
            this.validatorRule.validate(certificate);
            return true;
        }
        catch (CertificateValidationException e) {
            logger.info(e.getMessage());
            return false;
        }
    }

    public boolean isValid(InputStream inputStream) {
        try {
            return this.isValid(Validator.getCertificate(inputStream));
        }
        catch (CertificateValidationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isValid(byte[] bytes) {
        try {
            return this.isValid(Validator.getCertificate(bytes));
        }
        catch (CertificateValidationException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

