/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.extra;

import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.PrincipalNameProvider;
import no.difi.certvalidator.rule.PrincipalNameRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorwegianOrganizationNumberRule
extends PrincipalNameRule {
    private static final Logger logger = LoggerFactory.getLogger(NorwegianOrganizationNumberRule.class);
    private static final Pattern patternSerialnumber = Pattern.compile("^[0-9]{9}$");
    private static final Pattern patternOrganizationName = Pattern.compile("^.+\\-\\W*([0-9]{9})$");

    public NorwegianOrganizationNumberRule(PrincipalNameProvider provider) {
        super(provider);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        NorwegianOrganization organization = NorwegianOrganizationNumberRule.extractNumber(certificate);
        if (organization != null && this.provider.validate(organization.getNumber())) {
            return;
        }
        logger.debug("Organization number not detected. ({})", (Object)certificate.getSerialNumber());
        throw new FailedValidationException("Organization number not detected.");
    }

    public static NorwegianOrganization extractNumber(X509Certificate certificate) throws CertificateValidationException {
        try {
            for (String value : NorwegianOrganizationNumberRule.extract(NorwegianOrganizationNumberRule.getSubject(certificate), "SERIALNUMBER")) {
                if (!patternSerialnumber.matcher(value).matches()) continue;
                return new NorwegianOrganization(value, null);
            }
            for (String value : NorwegianOrganizationNumberRule.extract(NorwegianOrganizationNumberRule.getSubject(certificate), "O")) {
                Matcher matcher = patternOrganizationName.matcher(value);
                if (!matcher.matches()) continue;
                return new NorwegianOrganization(matcher.group(1), null);
            }
            return null;
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }

    public static class NorwegianOrganization {
        private String number;
        private String name;

        public NorwegianOrganization(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }
    }
}

