/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainRule
implements ValidatorRule {
    private static final Logger logger = LoggerFactory.getLogger(ChainRule.class);
    private CertificateBucket rootCertificates;
    private CertificateBucket intermediateCertificates;
    private Set<String> policies = new HashSet<String>();

    public ChainRule(CertificateBucket rootCertificates, CertificateBucket intermediateCertificates, String ... policies) {
        this.rootCertificates = rootCertificates;
        this.intermediateCertificates = intermediateCertificates;
        this.policies.addAll(Arrays.asList(policies));
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        try {
            PKIXCertPathBuilderResult result = this.verifyCertificate(certificate);
            for (Certificate certificate2 : result.getCertPath().getCertificates()) {
                logger.debug("({}) | {}", (Object)certificate.getSerialNumber(), (Object)((X509Certificate)certificate2).getSubjectX500Principal().getName());
            }
        }
        catch (GeneralSecurityException e) {
            logger.debug("({}) {}", (Object)certificate.getSerialNumber(), (Object)e.getMessage());
            throw new FailedValidationException(e.getMessage(), e);
        }
    }

    private PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert) throws GeneralSecurityException {
        logger.debug("({}) Chain: {}", (Object)cert.getSerialNumber(), (Object)cert.getSubjectX500Principal().getName());
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : this.rootCertificates) {
            logger.debug("({}) Trusted: {}", (Object)cert.getSerialNumber(), (Object)trustedRootCert.getSubjectDN().getName());
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        if (!this.policies.isEmpty()) {
            pkixParams.setInitialPolicies(this.policies);
            pkixParams.setExplicitPolicyRequired(true);
        }
        pkixParams.setRevocationEnabled(false);
        HashSet<X509Certificate> trustedIntermediateCert = new HashSet<X509Certificate>();
        for (X509Certificate certificate : this.intermediateCertificates) {
            logger.debug("({}) Intermediate: {}", (Object)cert.getSerialNumber(), (Object)certificate.getSubjectDN().getName());
            trustedIntermediateCert.add(certificate);
        }
        pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(trustedIntermediateCert)));
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }
}

