/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalOidRule
implements ValidatorRule {
    private static Logger logger = LoggerFactory.getLogger(CriticalOidRule.class);
    private List<String> approvedOids;

    public CriticalOidRule(String ... approvedOids) {
        this.approvedOids = Arrays.asList(approvedOids);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        Set<String> oids = certificate.getCriticalExtensionOIDs();
        if (oids == null) {
            throw new FailedValidationException("Certificate doesn't contain critical OIDs.");
        }
        for (String oid : oids) {
            if (this.approvedOids.contains(oid)) continue;
            logger.debug("Certificate doesn't contain critical OID '{}'. ({})", (Object)oid, (Object)certificate.getSerialNumber());
            throw new FailedValidationException(String.format("Certificate doesn't contain critical OID '%s'.", oid));
        }
    }
}

