/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationRule
implements ValidatorRule {
    private static final Logger logger = LoggerFactory.getLogger(ExpirationRule.class);

    @Override
    public void validate(X509Certificate certificate) throws FailedValidationException {
        try {
            certificate.checkValidity(new Date());
        }
        catch (CertificateNotYetValidException e) {
            logger.debug("Certificate not yet valid. ({})", (Object)certificate.getSerialNumber());
            throw new FailedValidationException("Certificate does not have a valid expiration date.");
        }
        catch (CertificateExpiredException e) {
            logger.debug("Certificate expired. ({})", (Object)certificate.getSerialNumber());
            throw new FailedValidationException("Certificate does not have a valid expiration date.");
        }
    }
}

