/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.structure;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;
import no.difi.certvalidator.structure.AbstractJunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrJunction
extends AbstractJunction {
    private static final Logger logger = LoggerFactory.getLogger(OrJunction.class);

    public OrJunction(ValidatorRule ... validatorRules) {
        super(validatorRules);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        ArrayList<CertificateValidationException> exceptions = new ArrayList<CertificateValidationException>();
        for (ValidatorRule validatorRule : this.validatorRules) {
            try {
                validatorRule.validate(certificate);
                return;
            }
            catch (CertificateValidationException certificateValidationException) {
                exceptions.add(certificateValidationException);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Or-junction failed with results:");
        for (Exception exception : exceptions) {
            stringBuilder.append("\n* ").append(exception.getMessage());
        }
        logger.debug("{}\n({})", (Object)stringBuilder.toString(), (Object)certificate.getSerialNumber());
        throw new FailedValidationException(stringBuilder.toString());
    }
}

