/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.CrlCache;
import no.difi.certvalidator.api.CrlFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCachingCrlFetcher
implements CrlFetcher {
    private static final Logger logger = LoggerFactory.getLogger(CrlFetcher.class);
    private static CertificateFactory certificateFactory;
    private CrlCache crlCache;

    public SimpleCachingCrlFetcher(CrlCache crlCache) {
        this.crlCache = crlCache;
    }

    @Override
    public X509CRL get(String url) throws CertificateValidationException {
        X509CRL crl = this.crlCache.get(url);
        if (crl == null) {
            crl = this.notInCache(url);
        } else if (crl.getNextUpdate() != null && crl.getNextUpdate().getTime() < System.currentTimeMillis()) {
            crl = this.outdated(url, crl);
        } else if (crl.getNextUpdate() == null) {
            logger.warn("Next update not set for CRL with URL \"{}\"", (Object)url);
        }
        return crl;
    }

    protected X509CRL notInCache(String url) throws CertificateValidationException {
        return this.download(url);
    }

    protected X509CRL outdated(String url, X509CRL outdatedCrl) throws CertificateValidationException {
        return this.download(url);
    }

    protected X509CRL download(String url) throws CertificateValidationException {
        logger.debug("Downloading CRL from {}...", (Object)url);
        try {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                X509CRL crl = (X509CRL)certificateFactory.generateCRL(URI.create(url).toURL().openStream());
                this.crlCache.set(url, crl);
                return crl;
            }
            if (url.startsWith("ldap://")) {
                return null;
            }
        }
        catch (Exception e) {
            throw new CertificateValidationException("Failed to download CRL " + url + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
        }
        return null;
    }

    static {
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to create X.509 certificate factory", e);
        }
    }
}

