/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Map;
import no.difi.certvalidator.Validator;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class ValidatorGroup
extends Validator {
    private Map<String, ValidatorRule> rulesMap;
    private String name;
    private String version;

    public ValidatorGroup(Map<String, ValidatorRule> rulesMap) {
        super(null);
        this.rulesMap = rulesMap;
    }

    public ValidatorGroup(Map<String, ValidatorRule> rulesMap, String name, String version) {
        this(rulesMap);
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        this.validate("default", certificate);
    }

    public void validate(String name, X509Certificate certificate) throws CertificateValidationException {
        if (!this.rulesMap.containsKey(name)) {
            throw new CertificateValidationException(String.format("Unknown validator '%s'.", name));
        }
        this.rulesMap.get(name).validate(certificate);
    }

    public X509Certificate validate(String name, InputStream inputStream) throws CertificateValidationException {
        X509Certificate certificate = ValidatorGroup.getCertificate(inputStream);
        this.validate(name, certificate);
        return certificate;
    }

    public X509Certificate validate(String name, byte[] bytes) throws CertificateValidationException {
        X509Certificate certificate = ValidatorGroup.getCertificate(bytes);
        this.validate(name, certificate);
        return certificate;
    }

    public boolean isValid(String name, X509Certificate certificate) {
        try {
            this.validate(name, certificate);
            return true;
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }

    public boolean isValid(String name, InputStream inputStream) {
        try {
            return this.isValid(name, ValidatorGroup.getCertificate(inputStream));
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }

    public boolean isValid(String name, byte[] bytes) {
        try {
            return this.isValid(name, ValidatorGroup.getCertificate(bytes));
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }
}

