/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import no.difi.certvalidator.Validator;
import no.difi.certvalidator.ValidatorGroup;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.CrlCache;
import no.difi.certvalidator.api.CrlFetcher;
import no.difi.certvalidator.api.PrincipalNameProvider;
import no.difi.certvalidator.api.ValidatorRule;
import no.difi.certvalidator.jaxb.CRLType;
import no.difi.certvalidator.jaxb.CachedType;
import no.difi.certvalidator.jaxb.CertificateBucketType;
import no.difi.certvalidator.jaxb.CertificateReferenceType;
import no.difi.certvalidator.jaxb.CertificateStartsWithType;
import no.difi.certvalidator.jaxb.CertificateType;
import no.difi.certvalidator.jaxb.ChainType;
import no.difi.certvalidator.jaxb.ClassType;
import no.difi.certvalidator.jaxb.CriticalExtensionRecognizedType;
import no.difi.certvalidator.jaxb.CriticalExtensionRequiredType;
import no.difi.certvalidator.jaxb.DummyType;
import no.difi.certvalidator.jaxb.ExpirationType;
import no.difi.certvalidator.jaxb.HandleErrorType;
import no.difi.certvalidator.jaxb.JunctionEnum;
import no.difi.certvalidator.jaxb.JunctionType;
import no.difi.certvalidator.jaxb.KeyStoreType;
import no.difi.certvalidator.jaxb.KeyUsageEnum;
import no.difi.certvalidator.jaxb.KeyUsageType;
import no.difi.certvalidator.jaxb.OCSPType;
import no.difi.certvalidator.jaxb.PrincipleNameType;
import no.difi.certvalidator.jaxb.RuleReferenceType;
import no.difi.certvalidator.jaxb.SigningEnum;
import no.difi.certvalidator.jaxb.SigningType;
import no.difi.certvalidator.jaxb.TryType;
import no.difi.certvalidator.jaxb.ValidatorRecipe;
import no.difi.certvalidator.jaxb.ValidatorReferenceType;
import no.difi.certvalidator.jaxb.ValidatorType;
import no.difi.certvalidator.lang.ValidatorParsingException;
import no.difi.certvalidator.rule.CRLRule;
import no.difi.certvalidator.rule.ChainRule;
import no.difi.certvalidator.rule.CriticalExtensionRecognizedRule;
import no.difi.certvalidator.rule.CriticalExtensionRequiredRule;
import no.difi.certvalidator.rule.DummyRule;
import no.difi.certvalidator.rule.ExpirationRule;
import no.difi.certvalidator.rule.ExpirationSoonRule;
import no.difi.certvalidator.rule.HandleErrorRule;
import no.difi.certvalidator.rule.KeyUsageRule;
import no.difi.certvalidator.rule.OCSPRule;
import no.difi.certvalidator.rule.PrincipalNameRule;
import no.difi.certvalidator.rule.SigningRule;
import no.difi.certvalidator.structure.Junction;
import no.difi.certvalidator.util.CachedValidatorRule;
import no.difi.certvalidator.util.KeyStoreCertificateBucket;
import no.difi.certvalidator.util.KeyUsage;
import no.difi.certvalidator.util.SimpleCachingCrlFetcher;
import no.difi.certvalidator.util.SimpleCertificateBucket;
import no.difi.certvalidator.util.SimpleCrlCache;
import no.difi.certvalidator.util.SimplePrincipalNameProvider;

class ValidatorLoaderParser {
    private static JAXBContext jaxbContext;

    ValidatorLoaderParser() {
    }

    public static ValidatorGroup parse(InputStream inputStream, Map<String, Object> objectStorage) throws ValidatorParsingException {
        try {
            ValidatorRecipe recipe = (ValidatorRecipe)jaxbContext.createUnmarshaller().unmarshal((Source)new StreamSource(inputStream), ValidatorRecipe.class).getValue();
            ValidatorLoaderParser.loadKeyStores(recipe, objectStorage);
            ValidatorLoaderParser.loadBuckets(recipe, objectStorage);
            HashMap<String, ValidatorRule> rulesMap = new HashMap<String, ValidatorRule>();
            for (ValidatorType validatorType : recipe.getValidator()) {
                ValidatorRule validatorRule = ValidatorLoaderParser.parse(validatorType.getCachedOrChainOrClazz(), objectStorage, JunctionEnum.AND);
                if (validatorType.getTimeout() != null) {
                    validatorRule = new CachedValidatorRule(validatorRule, validatorType.getTimeout());
                }
                String name = validatorType.getName() == null ? "default" : validatorType.getName();
                rulesMap.put(name, validatorRule);
                objectStorage.put(String.format("#validator::%s", name), validatorRule);
            }
            return new ValidatorGroup(rulesMap, recipe.getName(), recipe.getVersion());
        }
        catch (JAXBException | CertificateValidationException e) {
            throw new ValidatorParsingException(e.getMessage(), e);
        }
    }

    private static void loadKeyStores(ValidatorRecipe recipe, Map<String, Object> objectStorage) throws CertificateValidationException {
        for (KeyStoreType keyStoreType : recipe.getKeyStore()) {
            objectStorage.put(String.format("#keyStore::%s", keyStoreType.getName() == null ? "default" : keyStoreType.getName()), new KeyStoreCertificateBucket(new ByteArrayInputStream(keyStoreType.getValue()), keyStoreType.getPassword()));
        }
    }

    private static void loadBuckets(ValidatorRecipe recipe, Map<String, Object> objectStorage) throws CertificateValidationException {
        for (CertificateBucketType certificateBucketType : recipe.getCertificateBucket()) {
            SimpleCertificateBucket certificateBucket = new SimpleCertificateBucket(new X509Certificate[0]);
            for (Object o : certificateBucketType.getCertificateOrCertificateReferenceOrCertificateStartsWith()) {
                Object c;
                if (o instanceof CertificateType) {
                    certificateBucket.add(Validator.getCertificate(((CertificateType)o).getValue()));
                    continue;
                }
                if (o instanceof CertificateReferenceType) {
                    c = (CertificateReferenceType)o;
                    for (X509Certificate certificate : ValidatorLoaderParser.getKeyStore(((CertificateReferenceType)c).getKeyStore(), objectStorage).toSimple(((CertificateReferenceType)c).getValue())) {
                        certificateBucket.add(certificate);
                    }
                    continue;
                }
                c = (CertificateStartsWithType)o;
                for (X509Certificate certificate : ValidatorLoaderParser.getKeyStore(((CertificateStartsWithType)c).getKeyStore(), objectStorage).startsWith(((CertificateStartsWithType)c).getValue())) {
                    certificateBucket.add(certificate);
                }
            }
            objectStorage.put(String.format("#bucket::%s", certificateBucketType.getName()), certificateBucket);
        }
    }

    private static ValidatorRule parse(List<Object> rules, Map<String, Object> objectStorage, JunctionEnum junctionEnum) throws CertificateValidationException {
        ArrayList<ValidatorRule> ruleList = new ArrayList<ValidatorRule>();
        for (Object rule : rules) {
            ruleList.add(ValidatorLoaderParser.parse(rule, objectStorage));
        }
        if (junctionEnum == JunctionEnum.AND) {
            return Junction.and(ruleList.toArray(new ValidatorRule[ruleList.size()]));
        }
        if (junctionEnum == JunctionEnum.OR) {
            return Junction.or(ruleList.toArray(new ValidatorRule[ruleList.size()]));
        }
        return Junction.xor(ruleList.toArray(new ValidatorRule[ruleList.size()]));
    }

    private static ValidatorRule parse(Object rule, Map<String, Object> objectStorage) throws CertificateValidationException {
        if (rule instanceof CachedType) {
            return ValidatorLoaderParser.parse((CachedType)rule, objectStorage);
        }
        if (rule instanceof ChainType) {
            return ValidatorLoaderParser.parse((ChainType)rule, objectStorage);
        }
        if (rule instanceof ClassType) {
            return ValidatorLoaderParser.parse((ClassType)rule);
        }
        if (rule instanceof CriticalExtensionRecognizedType) {
            return ValidatorLoaderParser.parse((CriticalExtensionRecognizedType)rule);
        }
        if (rule instanceof CriticalExtensionRequiredType) {
            return ValidatorLoaderParser.parse((CriticalExtensionRequiredType)rule);
        }
        if (rule instanceof CRLType) {
            return ValidatorLoaderParser.parse((CRLType)rule, objectStorage);
        }
        if (rule instanceof DummyType) {
            return ValidatorLoaderParser.parse((DummyType)rule);
        }
        if (rule instanceof ExpirationType) {
            return ValidatorLoaderParser.parse((ExpirationType)rule);
        }
        if (rule instanceof JunctionType) {
            return ValidatorLoaderParser.parse((JunctionType)rule, objectStorage);
        }
        if (rule instanceof KeyUsageType) {
            return ValidatorLoaderParser.parse((KeyUsageType)rule);
        }
        if (rule instanceof OCSPType) {
            return ValidatorLoaderParser.parse((OCSPType)rule, objectStorage);
        }
        if (rule instanceof HandleErrorType) {
            return ValidatorLoaderParser.parse((HandleErrorType)rule, objectStorage);
        }
        if (rule instanceof PrincipleNameType) {
            return ValidatorLoaderParser.parse((PrincipleNameType)rule, objectStorage);
        }
        if (rule instanceof RuleReferenceType) {
            return ValidatorLoaderParser.parse((RuleReferenceType)rule, objectStorage);
        }
        if (rule instanceof SigningType) {
            return ValidatorLoaderParser.parse((SigningType)rule);
        }
        if (rule instanceof TryType) {
            return ValidatorLoaderParser.parse((TryType)rule, objectStorage);
        }
        return ValidatorLoaderParser.parse((ValidatorReferenceType)rule, objectStorage);
    }

    private static ValidatorRule parse(CachedType rule, Map<String, Object> objectStorage) throws CertificateValidationException {
        return new CachedValidatorRule(ValidatorLoaderParser.parse(rule.getCachedOrChainOrClazz(), objectStorage, JunctionEnum.AND), rule.getTimeout());
    }

    private static ValidatorRule parse(ChainType rule, Map<String, Object> objectStorage) {
        return new ChainRule(ValidatorLoaderParser.getBucket(rule.getRootBucketReference().getValue(), objectStorage), ValidatorLoaderParser.getBucket(rule.getIntermediateBucketReference().getValue(), objectStorage), rule.getPolicy().toArray(new String[rule.getPolicy().size()]));
    }

    private static ValidatorRule parse(ClassType rule) throws CertificateValidationException {
        try {
            return (ValidatorRule)Class.forName(rule.getValue()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CertificateValidationException(String.format("Unable to load rule '%s'.", rule.getValue()), e);
        }
    }

    private static ValidatorRule parse(CriticalExtensionRecognizedType rule) {
        return new CriticalExtensionRecognizedRule(rule.getValue().toArray(new String[rule.getValue().size()]));
    }

    private static ValidatorRule parse(CriticalExtensionRequiredType rule) {
        return new CriticalExtensionRequiredRule(rule.getValue().toArray(new String[rule.getValue().size()]));
    }

    private static ValidatorRule parse(CRLType rule, Map<String, Object> objectStorage) {
        if (!objectStorage.containsKey("crlFetcher") && !objectStorage.containsKey("crlCache")) {
            objectStorage.put("crlCache", new SimpleCrlCache());
        }
        if (!objectStorage.containsKey("crlFetcher")) {
            objectStorage.put("crlFetcher", new SimpleCachingCrlFetcher((CrlCache)objectStorage.get("crlCache")));
        }
        return new CRLRule((CrlFetcher)objectStorage.get("crlFetcher"));
    }

    private static ValidatorRule parse(DummyType dummyType) {
        return new DummyRule(dummyType.getValue());
    }

    private static ValidatorRule parse(ExpirationType expirationType) {
        if (expirationType.getMillis() == null) {
            return new ExpirationRule();
        }
        return new ExpirationSoonRule(expirationType.getMillis());
    }

    private static ValidatorRule parse(HandleErrorType optionalType, Map<String, Object> objectStorage) throws CertificateValidationException {
        ArrayList<ValidatorRule> validatorRules = new ArrayList<ValidatorRule>();
        for (Object o : optionalType.getCachedOrChainOrClazz()) {
            validatorRules.add(ValidatorLoaderParser.parse(o, objectStorage));
        }
        return new HandleErrorRule(validatorRules);
    }

    private static ValidatorRule parse(JunctionType junctionType, Map<String, Object> objectStorage) throws CertificateValidationException {
        return ValidatorLoaderParser.parse(junctionType.getCachedOrChainOrClazz(), objectStorage, junctionType.getType());
    }

    private static ValidatorRule parse(KeyUsageType keyUsageType) {
        List<KeyUsageEnum> keyUsages = keyUsageType.getIdentifier();
        KeyUsage[] result = new KeyUsage[keyUsages.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = KeyUsage.valueOf(keyUsages.get(i).name());
        }
        return new KeyUsageRule(result);
    }

    private static ValidatorRule parse(OCSPType ocspType, Map<String, Object> objectStorage) {
        return new OCSPRule(ValidatorLoaderParser.getBucket(ocspType.getIntermediateBucketReference().getValue(), objectStorage));
    }

    private static ValidatorRule parse(RuleReferenceType ruleReferenceType, Map<String, Object> objectStorage) throws CertificateValidationException {
        if (!objectStorage.containsKey(ruleReferenceType.getValue())) {
            throw new CertificateValidationException(String.format("Rule for '%s' not found.", ruleReferenceType.getValue()));
        }
        return (ValidatorRule)objectStorage.get(ruleReferenceType.getValue());
    }

    private static ValidatorRule parse(PrincipleNameType principleNameType, Map<String, Object> objectStorage) {
        PrincipalNameProvider<String> principalNameProvider = principleNameType.getReference() != null ? (PrincipalNameProvider)objectStorage.get(principleNameType.getReference().getValue()) : new SimplePrincipalNameProvider(principleNameType.getValue());
        return new PrincipalNameRule(principleNameType.getField(), principalNameProvider, principleNameType.getPrincipal() != null ? PrincipalNameRule.Principal.valueOf(principleNameType.getPrincipal().toString()) : PrincipalNameRule.Principal.SUBJECT);
    }

    private static ValidatorRule parse(SigningType signingType) {
        if (signingType.getType().equals((Object)SigningEnum.SELF_SIGNED)) {
            return SigningRule.SelfSignedOnly();
        }
        return SigningRule.PublicSignedOnly();
    }

    private static ValidatorRule parse(TryType tryType, Map<String, Object> objectStorage) throws CertificateValidationException {
        for (Object rule : tryType.getCachedOrChainOrClazz()) {
            try {
                return ValidatorLoaderParser.parse(rule, objectStorage);
            }
            catch (Exception exception) {
            }
        }
        throw new CertificateValidationException("Unable to find valid rule in try.");
    }

    private static ValidatorRule parse(ValidatorReferenceType validatorReferenceType, Map<String, Object> objectStorage) throws CertificateValidationException {
        String identifier = String.format("#validator::%s", validatorReferenceType.getValue());
        if (!objectStorage.containsKey(identifier)) {
            throw new CertificateValidationException(String.format("Unable to find validator '%s'.", validatorReferenceType.getValue()));
        }
        return (ValidatorRule)objectStorage.get(identifier);
    }

    private static KeyStoreCertificateBucket getKeyStore(String name, Map<String, Object> objectStorage) {
        return (KeyStoreCertificateBucket)objectStorage.get(String.format("#keyStore::%s", name == null ? "default" : name));
    }

    private static CertificateBucket getBucket(String name, Map<String, Object> objectStorage) {
        return (CertificateBucket)objectStorage.get(String.format("#bucket::%s", name));
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ValidatorRecipe.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

