/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.extra;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.PrincipalNameProvider;
import no.difi.certvalidator.rule.PrincipalNameRule;

public class NorwegianOrganizationNumberRule
extends PrincipalNameRule {
    private static final Pattern patternSerialnumber = Pattern.compile("^[0-9]{9}$");
    private static final Pattern patternOrganizationName = Pattern.compile("^.+\\-\\W*([0-9]{9})$");

    public NorwegianOrganizationNumberRule() {
        this(new PrincipalNameProvider<String>(){

            @Override
            public boolean validate(String value) {
                return true;
            }
        });
    }

    public NorwegianOrganizationNumberRule(PrincipalNameProvider<String> provider) {
        super(provider);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        NorwegianOrganization organization = NorwegianOrganizationNumberRule.extractNumber(certificate);
        if (organization != null && this.provider.validate(organization.getNumber())) {
            return;
        }
        throw new FailedValidationException("Organization number not detected.");
    }

    public static NorwegianOrganization extractNumber(X509Certificate certificate) throws CertificateValidationException {
        try {
            List<String> name = NorwegianOrganizationNumberRule.extract(NorwegianOrganizationNumberRule.getSubject(certificate), "O");
            for (String value : NorwegianOrganizationNumberRule.extract(NorwegianOrganizationNumberRule.getSubject(certificate), "SERIALNUMBER")) {
                if (!patternSerialnumber.matcher(value).matches()) continue;
                return new NorwegianOrganization(value, name.isEmpty() ? null : name.get(0));
            }
            for (String value : NorwegianOrganizationNumberRule.extract(NorwegianOrganizationNumberRule.getSubject(certificate), "O")) {
                Matcher matcher = patternOrganizationName.matcher(value);
                if (!matcher.matches()) continue;
                return new NorwegianOrganization(matcher.group(1), name.get(0));
            }
            return null;
        }
        catch (NullPointerException | CertificateEncodingException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }

    public static class NorwegianOrganization {
        private String number;
        private String name;

        public NorwegianOrganization(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }
    }
}

