/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class ChainRule
implements ValidatorRule {
    private CertificateBucket rootCertificates;
    private CertificateBucket intermediateCertificates;
    private Set<String> policies = new HashSet<String>();

    public ChainRule(CertificateBucket rootCertificates, CertificateBucket intermediateCertificates, String ... policies) {
        this.rootCertificates = rootCertificates;
        this.intermediateCertificates = intermediateCertificates;
        this.policies.addAll(Arrays.asList(policies));
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        try {
            this.verifyCertificate(certificate);
        }
        catch (GeneralSecurityException e) {
            throw new FailedValidationException(e.getMessage(), e);
        }
    }

    private PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert) throws GeneralSecurityException {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : this.rootCertificates) {
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        if (!this.policies.isEmpty()) {
            pkixParams.setInitialPolicies(this.policies);
            pkixParams.setExplicitPolicyRequired(true);
        }
        pkixParams.setRevocationEnabled(false);
        HashSet<X509Certificate> trustedIntermediateCert = new HashSet<X509Certificate>();
        for (X509Certificate certificate : this.intermediateCertificates) {
            trustedIntermediateCert.add(certificate);
        }
        pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(trustedIntermediateCert)));
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }
}

