/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class HandleErrorRule
implements ValidatorRule {
    private final List<ValidatorRule> validatorRules;

    public HandleErrorRule(ValidatorRule ... validatorRules) {
        this(Arrays.asList(validatorRules));
    }

    public HandleErrorRule(List<ValidatorRule> validatorRules) {
        this.validatorRules = validatorRules;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        for (ValidatorRule validatorRule : this.validatorRules) {
            try {
                validatorRule.validate(certificate);
            }
            catch (FailedValidationException e) {
                throw e;
            }
            catch (CertificateValidationException certificateValidationException) {
            }
        }
    }
}

