/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class CachedValidatorRule
extends CacheLoader<X509Certificate, Result>
implements ValidatorRule {
    private ValidatorRule validatorRule;
    private LoadingCache<X509Certificate, Result> cache;

    public CachedValidatorRule(ValidatorRule validatorRule, long timeout) {
        this.validatorRule = validatorRule;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(timeout, TimeUnit.SECONDS).build((CacheLoader)this);
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        ((Result)this.cache.getUnchecked((Object)certificate)).trigger();
    }

    public Result load(X509Certificate certificate) throws Exception {
        try {
            this.validatorRule.validate(certificate);
            return new Result();
        }
        catch (CertificateValidationException e) {
            return new Result(e);
        }
    }

    protected class Result {
        private CertificateValidationException exception;

        public Result() {
        }

        public Result(CertificateValidationException e) {
            this.exception = e;
        }

        public void trigger() throws CertificateValidationException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

