/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class ExpirationRule
implements ValidatorRule {
    @Override
    public void validate(X509Certificate certificate) throws FailedValidationException {
        try {
            certificate.checkValidity(new Date());
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            throw new FailedValidationException("Certificate does not have a valid expiration date.");
        }
    }
}

