/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.rule;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.klakegg.pkix.ocsp.OcspClient;
import net.klakegg.pkix.ocsp.OcspException;
import no.difi.certvalidator.api.CertificateBucket;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.FailedValidationException;
import no.difi.certvalidator.api.ValidatorRule;

public class OCSPRule
implements ValidatorRule {
    protected OcspClient ocspClient;

    public OCSPRule(CertificateBucket intermediateCertificates) {
        ArrayList<X509Certificate> intermediates = new ArrayList<X509Certificate>();
        for (X509Certificate intermediateCertificate : intermediateCertificates) {
            intermediates.add(intermediateCertificate);
        }
        this.ocspClient = (OcspClient)OcspClient.builder().set(OcspClient.INTERMEDIATES, intermediates).build();
    }

    public OCSPRule(OcspClient ocspClient) {
        this.ocspClient = ocspClient;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        try {
            this.ocspClient.verify(certificate);
        }
        catch (OcspException e) {
            throw new FailedValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }
}

