/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import java.net.URI;
import java.security.cert.X509CRL;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.CrlCache;
import no.difi.certvalidator.api.CrlFetcher;
import no.difi.certvalidator.util.CrlUtils;

public class SimpleCachingCrlFetcher
implements CrlFetcher {
    private CrlCache crlCache;

    public SimpleCachingCrlFetcher(CrlCache crlCache) {
        this.crlCache = crlCache;
    }

    @Override
    public X509CRL get(String url) throws CertificateValidationException {
        X509CRL crl = this.crlCache.get(url);
        if (crl == null) {
            crl = this.download(url);
        } else if (crl.getNextUpdate() != null && crl.getNextUpdate().getTime() < System.currentTimeMillis()) {
            crl = this.download(url);
        } else if (crl.getNextUpdate() == null) {
            // empty if block
        }
        return crl;
    }

    protected X509CRL download(String url) throws CertificateValidationException {
        try {
            if (url.matches("http[s]{0,1}://.*")) {
                X509CRL crl = CrlUtils.load(URI.create(url).toURL().openStream());
                this.crlCache.set(url, crl);
                return crl;
            }
            if (url.startsWith("ldap://")) {
                return null;
            }
        }
        catch (Exception e) {
            throw new CertificateValidationException(String.format("Failed to download CRL '%s' (%s)", url, e.getMessage()), e);
        }
        return null;
    }
}

