/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import no.difi.certvalidator.api.CertificateBucket;

public class SimpleCertificateBucket
implements CertificateBucket {
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();

    public SimpleCertificateBucket(X509Certificate ... certificates) {
        this.add(certificates);
    }

    public void add(X509Certificate ... certificates) {
        this.certificates.addAll(Arrays.asList(certificates));
    }

    @Override
    public X509Certificate findBySubject(X500Principal principal) {
        for (X509Certificate certificate : this.certificates) {
            if (!certificate.getSubjectX500Principal().equals(principal)) continue;
            return certificate;
        }
        return null;
    }

    @Override
    public Iterator<X509Certificate> iterator() {
        return this.certificates.iterator();
    }
}

