/*
 * Decompiled with CFR 0.152.
 */
package no.difi.certvalidator.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import no.difi.certvalidator.api.CertificateValidationException;
import no.difi.certvalidator.api.CrlCache;
import no.difi.certvalidator.util.CrlUtils;

public class DirectoryCrlCache
implements CrlCache {
    private Path folder;

    public DirectoryCrlCache(Path folder) throws IOException {
        this.folder = folder;
        Files.createDirectories(folder, new FileAttribute[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509CRL get(String url) throws CertificateValidationException {
        Path file = this.folder.resolve(this.filterUrl(url));
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            X509CRL x509CRL = CrlUtils.load(inputStream);
            return x509CRL;
        }
        catch (IOException | CRLException e) {
            return null;
        }
    }

    @Override
    public void set(String url, X509CRL crl) {
        Path file = this.folder.resolve(this.filterUrl(url));
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            CrlUtils.save(outputStream, crl);
        }
        catch (IOException | CRLException exception) {
            // empty catch block
        }
    }

    private String filterUrl(String s) {
        return s.replaceAll("[^a-zA-Z0-9.\\-]", "_");
    }
}

