/*
 * Decompiled with CFR 0.152.
 */
package no.difi.commons.schematron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;

public class SchematronTransformer {
    private static TransformerFactory transformerFactory = new TransformerFactoryImpl();
    private Transformer step1 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResource("/iso-schematron-xslt2/iso_dsdl_include.xsl").getFile()));
    private Transformer step2 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResource("/iso-schematron-xslt2/iso_abstract_expand.xsl").getFile()));
    private Transformer step3 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResource("/iso-schematron-xslt2/iso_svrl_for_xslt2.xsl").getFile()));

    public synchronized void transform(File inputFile, File outputFile) throws TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.step1.transform(new StreamSource(inputFile), new StreamResult(byteArrayOutputStream));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.step2.transform(new StreamSource(byteArrayInputStream), new StreamResult(byteArrayOutputStream));
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.step3.transform(new StreamSource(byteArrayInputStream), new StreamResult(outputFile));
    }
}

