/*
 * Decompiled with CFR 0.152.
 */
package no.difi.commons.schematron;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronTransformer {
    private static Logger logger = LoggerFactory.getLogger(SchematronTransformer.class);
    private static TransformerFactory transformerFactory;
    private Transformer step1 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/iso-schematron-xslt2/iso_dsdl_include.xsl")));
    private Transformer step2 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/iso-schematron-xslt2/iso_abstract_expand.xsl")));
    private Transformer step3 = transformerFactory.newTransformer(new StreamSource(this.getClass().getResourceAsStream("/iso-schematron-xslt2/iso_svrl_for_xslt2.xsl")));

    public void transform(File inputFile, File outputFile) throws TransformerException, IOException {
        this.transform(inputFile.toPath(), outputFile.toPath());
    }

    public void transform(Path inputFile, Path outputFile) throws TransformerException, IOException {
        OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);
        this.transform(inputFile, outputStream);
        outputStream.close();
    }

    public void transform(Path inputFile, OutputStream outputStream) throws TransformerException {
        this.transform(inputFile.toFile(), outputStream);
    }

    public synchronized void transform(File inputFile, OutputStream outputStream) throws TransformerException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.step1.transform(new StreamSource(inputFile), new StreamResult(byteArrayOutputStream));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream = new ByteArrayOutputStream();
        this.step2.transform(new StreamSource(byteArrayInputStream), new StreamResult(byteArrayOutputStream));
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.step3.transform(new StreamSource(byteArrayInputStream), new StreamResult(outputStream));
    }

    static {
        try {
            transformerFactory = (TransformerFactoryImpl)Class.forName("net.sf.saxon.TransformerFactoryImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
            logger.info("Using Saxon transformer.");
        }
        catch (Exception e) {
            transformerFactory = TransformerFactory.newInstance();
            logger.info("Using default transformer.");
        }
        transformerFactory.setURIResolver(new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                return !"".equals(base) ? null : new StreamSource(this.getClass().getResourceAsStream(String.format("/iso-schematron-xslt2/%s", href)));
            }
        });
    }
}

