/*
 * Decompiled with CFR 0.152.
 */
package no.difi.commons.schematron;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import no.difi.commons.schematron.ClasspathURIResolver;
import no.difi.commons.schematron.SaxonUtils;
import no.difi.commons.schematron.SchematronException;
import no.difi.commons.schematron.SchematronValidator;

public class SchematronCompiler
implements Closeable {
    private List<XsltExecutable> steps;
    private Processor processor;

    public SchematronCompiler() throws SchematronException {
        this(SaxonUtils.PROCESSOR);
    }

    public SchematronCompiler(Processor processor) throws SchematronException {
        this.processor = processor;
        XsltCompiler xsltCompiler = processor.newXsltCompiler();
        xsltCompiler.setURIResolver((URIResolver)new ClasspathURIResolver("/iso-schematron-xslt2"));
        this.steps = Arrays.asList(this.load("/iso-schematron-xslt2/iso_dsdl_include.xsl", xsltCompiler), this.load("/iso-schematron-xslt2/iso_abstract_expand.xsl", xsltCompiler), this.load("/iso-schematron-xslt2/iso_svrl_for_xslt2.xsl", xsltCompiler));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XsltExecutable load(String file, XsltCompiler xsltCompiler) throws SchematronException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(file);){
            XsltExecutable xsltExecutable = xsltCompiler.compile((Source)new StreamSource(inputStream));
            return xsltExecutable;
        }
        catch (IOException | SaxonApiException e) {
            throw new SchematronException(String.format("Unable to load file '%s'.", file), e);
        }
    }

    public void compile(File inputFile, File outputFile) throws SchematronException, IOException {
        this.compile(inputFile.toPath(), outputFile.toPath());
    }

    public void compile(Path inputFile, Path outputFile) throws SchematronException, IOException {
        try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);){
            this.compile(inputFile, outputStream);
        }
    }

    public void compile(Path inputFile, OutputStream outputStream) throws SchematronException {
        this.compile(inputFile.toFile(), outputStream);
    }

    public void compile(File inputFile, OutputStream outputStream) throws SchematronException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            XdmDestination destination = new XdmDestination();
            this.compile(inputFile, (Destination)destination);
            bufferedOutputStream.write(SaxonUtils.xdmToBytes(destination));
        }
        catch (IOException e) {
            throw new SchematronException(String.format("Unable to compile '%s'.", inputFile), e);
        }
    }

    public SchematronValidator createValidator(File inputFile) throws SchematronException {
        XdmDestination destination = new XdmDestination();
        this.compile(inputFile, (Destination)destination);
        return new SchematronValidator(SaxonUtils.xdmToInputStream(destination), this.processor);
    }

    public void compile(File inputFile, Destination destination) throws SchematronException {
        XsltTransformer firstTransformer = null;
        XsltTransformer lastTransformer = null;
        ArrayList<XsltTransformer> xsltTransformers = new ArrayList<XsltTransformer>();
        for (XsltExecutable xsltExecutable : this.steps) {
            XsltTransformer xsltTransformer = xsltExecutable.load();
            if (lastTransformer != null) {
                lastTransformer.setDestination((Destination)xsltTransformer);
            } else {
                firstTransformer = xsltTransformer;
            }
            lastTransformer = xsltTransformer;
            xsltTransformers.add(xsltTransformer);
        }
        try {
            lastTransformer.setDestination(destination);
            firstTransformer.setSource((Source)new StreamSource(inputFile));
            firstTransformer.transform();
            for (XsltTransformer xsltTransformer : xsltTransformers) {
                xsltTransformer.close();
            }
        }
        catch (SaxonApiException e) {
            throw new SchematronException(String.format("Unable to compile '%s'.", inputFile), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.steps.clear();
        this.steps = null;
        this.processor = null;
    }
}

