/*
 * Decompiled with CFR 0.152.
 */
package no.difi.commons.schematron;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import no.difi.commons.schematron.SaxonUtils;
import no.difi.commons.schematron.SchematronException;
import no.difi.commons.schematron.jaxb.svrl.SchematronOutput;

public class SchematronValidator {
    private static JAXBContext jaxbContext;
    private XsltExecutable xsltExecutable;

    public SchematronValidator(InputStream inputStream) throws SchematronException {
        this(inputStream, SaxonUtils.PROCESSOR);
    }

    public SchematronValidator(InputStream inputStream, Processor processor) throws SchematronException {
        try {
            XsltCompiler xsltCompiler = processor.newXsltCompiler();
            this.xsltExecutable = xsltCompiler.compile((Source)new StreamSource(inputStream));
        }
        catch (SaxonApiException e) {
            throw new SchematronException("Unable to load Schematron XSLT.", e);
        }
    }

    public SchematronOutput validate(InputStream inputStream) throws SchematronException {
        try {
            XdmDestination destination = new XdmDestination();
            this.validate(inputStream, (Destination)destination);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (SchematronOutput)unmarshaller.unmarshal((Source)new StreamSource(SaxonUtils.xdmToInputStream(destination)), SchematronOutput.class).getValue();
        }
        catch (JAXBException e) {
            throw new SchematronException("Unable to parse validation result.", e);
        }
    }

    public void validate(InputStream inputStream, Destination destination) throws SchematronException {
        try {
            XsltTransformer xsltTransformer = this.xsltExecutable.load();
            xsltTransformer.setSource((Source)new StreamSource(inputStream));
            xsltTransformer.setDestination(destination);
            xsltTransformer.transform();
            xsltTransformer.close();
        }
        catch (SaxonApiException e) {
            throw new SchematronException("Unable to validate document.", e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SchematronOutput.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

