/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import no.difi.sdp.client2.domain.Miljo;
import no.digipost.api.representations.Organisasjonsnummer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;

public class KlientKonfigurasjon {
    private final Miljo miljo;
    private String proxyHost;
    private int proxyPort;
    private String proxyScheme = "https";
    private int maxConnectionPoolSize = 10;
    private long socketTimeoutInMillis = TimeUnit.SECONDS.toMillis(30L);
    private long connectTimeoutInMillis = TimeUnit.SECONDS.toMillis(10L);
    private long connectionRequestTimeoutInMillis = TimeUnit.SECONDS.toMillis(10L);
    private HttpRequestInterceptor[] httpRequestInterceptors = new HttpRequestInterceptor[0];
    private HttpResponseInterceptor[] httpResponseInterceptors = new HttpResponseInterceptor[0];

    public static Builder builder(Miljo miljo) {
        return new Builder(miljo);
    }

    @Deprecated
    public static Builder builder(String integrasjonspunktRootUri) {
        return KlientKonfigurasjon.builder(URI.create(integrasjonspunktRootUri));
    }

    public static Builder builder(URI integrasjonspunktRoot) {
        return new Builder(new Miljo(integrasjonspunktRoot));
    }

    private KlientKonfigurasjon(Miljo miljo) {
        this.miljo = miljo;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public long getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public long getConnectTimeoutInMillis() {
        return this.connectTimeoutInMillis;
    }

    public long getConnectionRequestTimeoutInMillis() {
        return this.connectionRequestTimeoutInMillis;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public boolean useProxy() {
        return !StringUtils.isEmpty((CharSequence)this.proxyHost) && this.proxyPort > 0;
    }

    @Deprecated
    public Organisasjonsnummer getMeldingsformidlerOrganisasjon() {
        return Organisasjonsnummer.of("984661185");
    }

    public HttpRequestInterceptor[] getHttpRequestInterceptors() {
        return this.httpRequestInterceptors;
    }

    public HttpResponseInterceptor[] getHttpResponseInterceptors() {
        return this.httpResponseInterceptors;
    }

    public Miljo getMiljo() {
        return this.miljo;
    }

    public URI getIntegrasjonspunktRoot() {
        return this.miljo.getIntegrasjonspunktRoot();
    }

    static /* synthetic */ HttpRequestInterceptor[] access$902(KlientKonfigurasjon x0, HttpRequestInterceptor[] x1) {
        x0.httpRequestInterceptors = x1;
        return x1;
    }

    static /* synthetic */ HttpResponseInterceptor[] access$1002(KlientKonfigurasjon x0, HttpResponseInterceptor[] x1) {
        x0.httpResponseInterceptors = x1;
        return x1;
    }

    public static class Builder {
        private final KlientKonfigurasjon target;

        private Builder(Miljo miljo) {
            this.target = new KlientKonfigurasjon(miljo);
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.target.proxyHost = proxyHost;
            this.target.proxyPort = proxyPort;
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort, String proxyScheme) {
            this.target.proxyHost = proxyHost;
            this.target.proxyPort = proxyPort;
            this.target.proxyScheme = proxyScheme;
            return this;
        }

        public Builder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
            this.target.socketTimeoutInMillis = timeUnit.toMillis(socketTimeout);
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout, TimeUnit timeUnit) {
            this.target.connectTimeoutInMillis = timeUnit.toMillis(connectionTimeout);
            return this;
        }

        public Builder connectionRequestTimeout(int connectionRequestTimeout, TimeUnit timeUnit) {
            this.target.connectionRequestTimeoutInMillis = timeUnit.toMillis(connectionRequestTimeout);
            return this;
        }

        public Builder maxConnectionPoolSize(int maxConnectionPoolSize) {
            this.target.maxConnectionPoolSize = maxConnectionPoolSize;
            return this;
        }

        public Builder httpRequestInterceptors(HttpRequestInterceptor ... httpRequestInterceptors) {
            KlientKonfigurasjon.access$902(this.target, httpRequestInterceptors);
            return this;
        }

        public Builder httpResponseInterceptors(HttpResponseInterceptor ... httpResponseInterceptors) {
            KlientKonfigurasjon.access$1002(this.target, httpResponseInterceptors);
            return this;
        }

        public KlientKonfigurasjon build() {
            return this.target;
        }
    }
}

