/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain;

import no.difi.sdp.client2.domain.AvsenderOrganisasjonsnummer;

public class Avsender {
    private final AvsenderOrganisasjonsnummer organisasjonsnummer;
    private String avsenderIdentifikator;
    private String fakturaReferanse;

    public Avsender(AvsenderOrganisasjonsnummer organisasjonsnummer) {
        this.organisasjonsnummer = organisasjonsnummer;
    }

    public static Builder builder(AvsenderOrganisasjonsnummer organisasjonsnummer) {
        return new Builder(organisasjonsnummer);
    }

    public String getAvsenderIdentifikator() {
        return this.avsenderIdentifikator;
    }

    public String getFakturaReferanse() {
        return this.fakturaReferanse;
    }

    public AvsenderOrganisasjonsnummer getOrganisasjonsnummer() {
        return this.organisasjonsnummer;
    }

    public static class Builder {
        private final Avsender target;
        private boolean built = false;

        private Builder(AvsenderOrganisasjonsnummer organisasjonsnummer) {
            this.target = new Avsender(organisasjonsnummer);
        }

        public Builder fakturaReferanse(String fakturaReferanse) {
            this.target.fakturaReferanse = fakturaReferanse;
            return this;
        }

        public Builder avsenderIdentifikator(String avsenderIdentifikator) {
            this.target.avsenderIdentifikator = avsenderIdentifikator;
            return this;
        }

        public Avsender build() {
            if (this.built) {
                throw new IllegalStateException("Kan ikke bygges flere ganger.");
            }
            this.built = true;
            return this.target;
        }
    }
}

