/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import no.difi.sdp.client2.domain.Dokument;
import no.difi.sdp.client2.domain.exceptions.SikkerDigitalPostException;

public class Dokumentpakke {
    private Dokument hoveddokument;
    private List<Dokument> vedlegg = Collections.emptyList();

    private Dokumentpakke(Dokument hoveddokument) {
        this.hoveddokument = hoveddokument;
    }

    public Dokument getHoveddokument() {
        return this.hoveddokument;
    }

    public List<Dokument> getVedlegg() {
        return this.vedlegg;
    }

    public Stream<Dokument> getHoveddokumentOgVedlegg() {
        return Stream.concat(Stream.of(this.hoveddokument), this.vedlegg.stream());
    }

    public static Builder builder(Dokument hoveddokument) {
        return new Builder(hoveddokument);
    }

    public static class Builder {
        private final Dokumentpakke target;
        private boolean built = false;

        private Builder(Dokument hoveddokument) {
            this.target = new Dokumentpakke(hoveddokument);
        }

        public Builder vedlegg(List<Dokument> vedlegg) {
            boolean hasMetadatadokument = vedlegg.stream().map(Dokument::getMetadataDocument).anyMatch(Optional::isPresent);
            if (hasMetadatadokument) {
                throw new SikkerDigitalPostException("Vedlegg st\u00f8tter ikke metadatadokument/utvidelser.");
            }
            this.target.vedlegg = new ArrayList<Dokument>(vedlegg);
            return this;
        }

        public Builder vedlegg(Dokument ... vedlegg) {
            return this.vedlegg(Arrays.asList(vedlegg));
        }

        public Dokumentpakke build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

